/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq;

import com.primeton.pmq.PMQConnection;
import com.primeton.pmq.PMQDispatcher;
import com.primeton.pmq.advisory.AdvisorySupport;
import com.primeton.pmq.command.ConsumerId;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.DataStructure;
import com.primeton.pmq.command.DestinationInfo;
import com.primeton.pmq.command.MessageAck;
import com.primeton.pmq.command.MessageDispatch;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQTempDestination;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvisoryConsumer
implements PMQDispatcher {
    private static final transient Logger LOG = LoggerFactory.getLogger(AdvisoryConsumer.class);
    int deliveredCounter;
    private final PMQConnection connection;
    private ConsumerInfo info;
    private boolean closed;

    public AdvisoryConsumer(PMQConnection connection, ConsumerId consumerId) throws JMSException {
        this.connection = connection;
        this.info = new ConsumerInfo(consumerId);
        this.info.setDestination(AdvisorySupport.TEMP_DESTINATION_COMPOSITE_ADVISORY_TOPIC);
        this.info.setPrefetchSize(1000);
        this.info.setNoLocal(true);
        this.info.setDispatchAsync(true);
        this.connection.addDispatcher(this.info.getConsumerId(), this);
        this.connection.syncSendPacket(this.info);
    }

    public synchronized void dispose() {
        if (!this.closed) {
            try {
                this.connection.asyncSendPacket(this.info.createRemoveCommand());
            }
            catch (JMSException e) {
                LOG.debug("Failed to send remove command: " + e, e);
            }
            this.connection.removeDispatcher(this.info.getConsumerId());
            this.closed = true;
        }
    }

    @Override
    public void dispatch(MessageDispatch md) {
        DataStructure o;
        ++this.deliveredCounter;
        if ((double)this.deliveredCounter > 0.75 * (double)this.info.getPrefetchSize()) {
            try {
                MessageAck ack = new MessageAck(md, 2, this.deliveredCounter);
                this.connection.asyncSendPacket(ack);
                this.deliveredCounter = 0;
            }
            catch (JMSException e) {
                this.connection.onClientInternalException(e);
            }
        }
        if ((o = md.getMessage().getDataStructure()) != null && o.getClass() == DestinationInfo.class) {
            this.processDestinationInfo((DestinationInfo)o);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Unexpected message was dispatched to the AdvisoryConsumer: " + md);
        }
    }

    private void processDestinationInfo(DestinationInfo dinfo) {
        PMQDestination dest = dinfo.getDestination();
        if (!dest.isTemporary()) {
            return;
        }
        PMQTempDestination tempDest = (PMQTempDestination)dest;
        if (dinfo.getOperationType() == 0) {
            if (tempDest.getConnection() != null) {
                tempDest = (PMQTempDestination)tempDest.createDestination(tempDest.getPhysicalName());
            }
            this.connection.activeTempDestinations.put(tempDest, tempDest);
        } else if (dinfo.getOperationType() == 1) {
            this.connection.activeTempDestinations.remove(tempDest);
        }
    }
}

