/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq;

import com.primeton.pmq.PMQConnection;
import com.primeton.pmq.PMQDispatcher;
import com.primeton.pmq.PMQQueueSession;
import com.primeton.pmq.PMQSession;
import com.primeton.pmq.PMQTopicSession;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.MessageDispatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;

public class PMQConnectionConsumer
implements ConnectionConsumer,
PMQDispatcher {
    private PMQConnection connection;
    private ServerSessionPool sessionPool;
    private ConsumerInfo consumerInfo;
    private boolean closed;

    protected PMQConnectionConsumer(PMQConnection theConnection, ServerSessionPool theSessionPool, ConsumerInfo theConsumerInfo) throws JMSException {
        this.connection = theConnection;
        this.sessionPool = theSessionPool;
        this.consumerInfo = theConsumerInfo;
        this.connection.addConnectionConsumer(this);
        this.connection.addDispatcher(this.consumerInfo.getConsumerId(), this);
        this.connection.syncSendPacket(this.consumerInfo);
    }

    @Override
    public ServerSessionPool getServerSessionPool() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The Connection Consumer is closed");
        }
        return this.sessionPool;
    }

    @Override
    public void close() throws JMSException {
        if (!this.closed) {
            this.dispose();
            this.connection.asyncSendPacket(this.consumerInfo.createRemoveCommand());
        }
    }

    public void dispose() {
        if (!this.closed) {
            this.connection.removeDispatcher(this.consumerInfo.getConsumerId());
            this.connection.removeConnectionConsumer(this);
            this.closed = true;
        }
    }

    @Override
    public void dispatch(MessageDispatch messageDispatch) {
        try {
            messageDispatch.setConsumer(this);
            ServerSession serverSession = this.sessionPool.getServerSession();
            Session s = serverSession.getSession();
            PMQSession session = null;
            if (s instanceof PMQSession) {
                session = (PMQSession)s;
            } else if (s instanceof PMQTopicSession) {
                PMQTopicSession topicSession = (PMQTopicSession)s;
                session = (PMQSession)topicSession.getNext();
            } else if (s instanceof PMQQueueSession) {
                PMQQueueSession queueSession = (PMQQueueSession)s;
                session = (PMQSession)queueSession.getNext();
            } else {
                this.connection.onClientInternalException(new JMSException("Session pool provided an invalid session type: " + s.getClass()));
                return;
            }
            session.dispatch(messageDispatch);
            serverSession.start();
        }
        catch (JMSException e) {
            this.connection.onAsyncException(e);
        }
    }

    public String toString() {
        return "PMQConnectionConsumer { value=" + this.consumerInfo.getConsumerId() + " }";
    }

    public void clearMessagesInProgress(AtomicInteger transportInterruptionProcessingComplete) {
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }
}

