/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq;

import com.primeton.pmq.PMQConnection;
import com.primeton.pmq.PMQSslConnectionFactory;
import com.primeton.pmq.PMQXAConnection;
import com.primeton.pmq.management.JMSStatsImpl;
import com.primeton.pmq.transport.Transport;
import java.net.URI;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;

public class PMQXASslConnectionFactory
extends PMQSslConnectionFactory
implements XAConnectionFactory,
XAQueueConnectionFactory,
XATopicConnectionFactory {
    public PMQXASslConnectionFactory() {
    }

    public PMQXASslConnectionFactory(String brokerURL) {
        super(brokerURL);
    }

    public PMQXASslConnectionFactory(URI brokerURL) {
        super(brokerURL);
    }

    @Override
    public XAConnection createXAConnection() throws JMSException {
        return (XAConnection)((Object)this.createPMQConnection());
    }

    @Override
    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        return (XAConnection)((Object)this.createPMQConnection(userName, password));
    }

    @Override
    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)((Object)this.createPMQConnection());
    }

    @Override
    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        return (XAQueueConnection)((Object)this.createPMQConnection(userName, password));
    }

    @Override
    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)((Object)this.createPMQConnection());
    }

    @Override
    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        return (XATopicConnection)((Object)this.createPMQConnection(userName, password));
    }

    @Override
    protected PMQConnection createPMQConnection(Transport transport, JMSStatsImpl stats) throws Exception {
        PMQXAConnection connection = new PMQXAConnection(transport, this.getClientIdGenerator(), this.getConnectionIdGenerator(), stats);
        this.configureXAConnection(connection);
        return connection;
    }

    private void configureXAConnection(PMQXAConnection connection) {
        connection.setXaAckMode(this.xaAckMode);
    }

    public int getXaAckMode() {
        return this.xaAckMode;
    }

    public void setXaAckMode(int xaAckMode) {
        this.xaAckMode = xaAckMode;
    }

    @Override
    public void populateProperties(Properties props) {
        super.populateProperties(props);
        props.put("xaAckMode", Integer.toString(this.xaAckMode));
    }
}

