/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.advisory;

import com.primeton.pmq.advisory.AdvisorySupport;
import com.primeton.pmq.advisory.DestinationFilterVirtualDestinationMatcher;
import com.primeton.pmq.advisory.VirtualDestinationMatcher;
import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.TransportConnector;
import com.primeton.pmq.broker.region.BaseDestination;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DurableTopicSubscription;
import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.RegionBroker;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.TopicRegion;
import com.primeton.pmq.broker.region.TopicSubscription;
import com.primeton.pmq.broker.region.virtual.VirtualDestination;
import com.primeton.pmq.broker.region.virtual.VirtualTopic;
import com.primeton.pmq.command.BrokerInfo;
import com.primeton.pmq.command.Command;
import com.primeton.pmq.command.ConnectionId;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.command.ConsumerId;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.DestinationInfo;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.MessageId;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.ProducerId;
import com.primeton.pmq.command.ProducerInfo;
import com.primeton.pmq.command.RemoveSubscriptionInfo;
import com.primeton.pmq.command.SessionId;
import com.primeton.pmq.filter.DestinationPath;
import com.primeton.pmq.security.SecurityContext;
import com.primeton.pmq.state.ProducerState;
import com.primeton.pmq.usage.Usage;
import com.primeton.pmq.util.IdGenerator;
import com.primeton.pmq.util.LongSequenceGenerator;
import com.primeton.pmq.util.SubscriptionKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvisoryBroker
extends BrokerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AdvisoryBroker.class);
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    protected final ConcurrentMap<ConnectionId, ConnectionInfo> connections = new ConcurrentHashMap<ConnectionId, ConnectionInfo>();
    private final ReentrantReadWriteLock consumersLock = new ReentrantReadWriteLock();
    protected final Map<ConsumerId, ConsumerInfo> consumers = new LinkedHashMap<ConsumerId, ConsumerInfo>();
    protected final Set<VirtualDestination> virtualDestinations = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final ConcurrentMap<ConsumerInfo, VirtualDestination> virtualDestinationConsumers = new ConcurrentHashMap<ConsumerInfo, VirtualDestination>();
    protected final ConcurrentMap<VirtualConsumerPair, ConsumerInfo> brokerConsumerDests = new ConcurrentHashMap<VirtualConsumerPair, ConsumerInfo>();
    protected final ConcurrentMap<ProducerId, ProducerInfo> producers = new ConcurrentHashMap<ProducerId, ProducerInfo>();
    protected final ConcurrentMap<PMQDestination, DestinationInfo> destinations = new ConcurrentHashMap<PMQDestination, DestinationInfo>();
    protected final ConcurrentMap<BrokerInfo, PMQMessage> networkBridges = new ConcurrentHashMap<BrokerInfo, PMQMessage>();
    protected final ProducerId advisoryProducerId = new ProducerId();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private VirtualDestinationMatcher virtualDestinationMatcher = new DestinationFilterVirtualDestinationMatcher();
    private final IdGenerator connectionIdGenerator = new IdGenerator("advisory");
    private final LongSequenceGenerator sessionIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();

    public AdvisoryBroker(Broker next) {
        super(next);
        this.advisoryProducerId.setConnectionId(ID_GENERATOR.generateId());
    }

    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        super.addConnection(context, info);
        PMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        ConnectionInfo copy = info.copy();
        copy.setPassword("");
        this.fireAdvisory(context, topic, copy);
        this.connections.put(copy.getConnectionId(), copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Subscription answer = super.addConsumer(context, info);
        if (!AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            PMQTopic topic = AdvisorySupport.getConsumerAdvisoryTopic(info.getDestination());
            this.consumersLock.writeLock().lock();
            try {
                this.consumers.put(info.getConsumerId(), info);
                if (this.getBrokerService().isUseVirtualDestSubs()) {
                    for (VirtualDestination virtualDestination : this.virtualDestinations) {
                        if (!this.virtualDestinationMatcher.matches(virtualDestination, info.getDestination())) continue;
                        this.fireVirtualDestinationAddAdvisory(context, info, info.getDestination(), virtualDestination);
                    }
                }
            }
            finally {
                this.consumersLock.writeLock().unlock();
            }
            this.fireConsumerAdvisory(context, info.getDestination(), topic, info);
        } else {
            PMQTopic topic;
            if (AdvisorySupport.isConnectionAdvisoryTopic(info.getDestination())) {
                for (ConnectionInfo connectionInfo : this.connections.values()) {
                    topic = AdvisorySupport.getConnectionAdvisoryTopic();
                    this.fireAdvisory(context, topic, connectionInfo, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isTempDestinationAdvisoryTopic(info.getDestination())) {
                for (DestinationInfo destinationInfo : this.destinations.values()) {
                    if (!destinationInfo.getDestination().isTemporary()) continue;
                    topic = AdvisorySupport.getDestinationAdvisoryTopic(destinationInfo.getDestination());
                    this.fireAdvisory(context, topic, destinationInfo, info.getConsumerId());
                }
            } else if (AdvisorySupport.isDestinationAdvisoryTopic(info.getDestination())) {
                for (DestinationInfo destinationInfo : this.destinations.values()) {
                    topic = AdvisorySupport.getDestinationAdvisoryTopic(destinationInfo.getDestination());
                    this.fireAdvisory(context, topic, destinationInfo, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isProducerAdvisoryTopic(info.getDestination())) {
                for (ProducerInfo producerInfo : this.producers.values()) {
                    topic = AdvisorySupport.getProducerAdvisoryTopic(producerInfo.getDestination());
                    this.fireProducerAdvisory(context, producerInfo.getDestination(), topic, producerInfo, info.getConsumerId());
                }
            }
            if (AdvisorySupport.isConsumerAdvisoryTopic(info.getDestination())) {
                this.consumersLock.readLock().lock();
                try {
                    for (ConsumerInfo consumerInfo : this.consumers.values()) {
                        topic = AdvisorySupport.getConsumerAdvisoryTopic(consumerInfo.getDestination());
                        this.fireConsumerAdvisory(context, consumerInfo.getDestination(), topic, consumerInfo, info.getConsumerId());
                    }
                }
                finally {
                    this.consumersLock.readLock().unlock();
                }
            }
            if (AdvisorySupport.isVirtualDestinationConsumerAdvisoryTopic(info.getDestination())) {
                for (ConsumerInfo consumerInfo : this.virtualDestinationConsumers.keySet()) {
                    topic = AdvisorySupport.getVirtualDestinationConsumerAdvisoryTopic(consumerInfo.getDestination());
                    this.fireConsumerAdvisory(context, consumerInfo.getDestination(), topic, consumerInfo);
                }
            }
            if (AdvisorySupport.isNetworkBridgeAdvisoryTopic(info.getDestination())) {
                for (BrokerInfo brokerInfo : this.networkBridges.keySet()) {
                    topic = AdvisorySupport.getNetworkBridgeAdvisoryTopic();
                    this.fireAdvisory(context, topic, brokerInfo, null, (PMQMessage)this.networkBridges.get(brokerInfo));
                }
            }
        }
        return answer;
    }

    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.addProducer(context, info);
        if ((info.getDestination() != null || this.getBrokerService().isAnonymousProducerAdvisorySupport()) && !AdvisorySupport.isAdvisoryTopic(info.getDestination())) {
            PMQTopic topic = AdvisorySupport.getProducerAdvisoryTopic(info.getDestination());
            this.fireProducerAdvisory(context, info.getDestination(), topic, info);
            this.producers.put(info.getProducerId(), info);
        }
    }

    @Override
    public Destination addDestination(ConnectionContext context, PMQDestination destination, boolean create) throws Exception {
        Destination answer = super.addDestination(context, destination, create);
        if (!AdvisorySupport.isAdvisoryTopic(destination)) {
            DestinationInfo info;
            DestinationInfo previous;
            if (this.getBrokerService().isUseVirtualDestSubsOnCreation() && destination.isQueue()) {
                for (VirtualDestination virtualDestination : this.virtualDestinations) {
                    if (!this.virtualDestinationMatcher.matches(virtualDestination, destination)) continue;
                    this.fireVirtualDestinationAddAdvisory(context, null, destination, virtualDestination);
                }
            }
            if ((previous = this.destinations.putIfAbsent(destination, info = new DestinationInfo(context.getConnectionId(), 0, destination))) == null) {
                PMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
                this.fireAdvisory(context, topic, info);
            }
        }
        return answer;
    }

    @Override
    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        DestinationInfo previous;
        PMQDestination destination = info.getDestination();
        this.next.addDestinationInfo(context, info);
        if (!AdvisorySupport.isAdvisoryTopic(destination) && (previous = this.destinations.putIfAbsent(destination, info)) == null) {
            PMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
            this.fireAdvisory(context, topic, info);
        }
    }

    @Override
    public void removeDestination(ConnectionContext context, PMQDestination destination, long timeout) throws Exception {
        super.removeDestination(context, destination, timeout);
        DestinationInfo info = (DestinationInfo)this.destinations.remove(destination);
        if (info != null) {
            PMQTopic[] advisoryDestinations;
            if (this.getBrokerService().isUseVirtualDestSubs()) {
                for (ConsumerInfo consumerInfo : this.virtualDestinationConsumers.keySet()) {
                    VirtualConsumerPair key;
                    ConsumerInfo i;
                    VirtualDestination virtualDestination = (VirtualDestination)this.virtualDestinationConsumers.get(consumerInfo);
                    if (!this.virtualDestinationMatcher.matches(virtualDestination, destination) || !consumerInfo.equals(i = (ConsumerInfo)this.brokerConsumerDests.get(key = new VirtualConsumerPair(virtualDestination, destination))) || this.brokerConsumerDests.remove(key) == null) continue;
                    LOG.debug("Virtual consumer pair removed: {} for consumer: {} ", (Object)key, (Object)i);
                    this.fireVirtualDestinationRemoveAdvisory(context, consumerInfo);
                    break;
                }
            }
            info = info.copy();
            info.setDestination(destination);
            info.setOperationType((byte)1);
            PMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destination);
            this.fireAdvisory(context, topic, info);
            for (PMQTopic advisoryDestination : advisoryDestinations = AdvisorySupport.getAllDestinationAdvisoryTopics(destination)) {
                try {
                    this.next.removeDestination(context, advisoryDestination, -1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void removeDestinationInfo(ConnectionContext context, DestinationInfo destInfo) throws Exception {
        super.removeDestinationInfo(context, destInfo);
        DestinationInfo info = (DestinationInfo)this.destinations.remove(destInfo.getDestination());
        if (info != null) {
            PMQTopic[] advisoryDestinations;
            info = info.copy();
            info.setDestination(destInfo.getDestination());
            info.setOperationType((byte)1);
            PMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic(destInfo.getDestination());
            this.fireAdvisory(context, topic, info);
            for (PMQTopic advisoryDestination : advisoryDestinations = AdvisorySupport.getAllDestinationAdvisoryTopics(destInfo.getDestination())) {
                try {
                    this.next.removeDestination(context, advisoryDestination, -1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        PMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        this.fireAdvisory(context, topic, info.createRemoveCommand());
        this.connections.remove(info.getConnectionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        super.removeConsumer(context, info);
        PMQDestination dest = info.getDestination();
        if (!AdvisorySupport.isAdvisoryTopic(dest)) {
            PMQTopic topic = AdvisorySupport.getConsumerAdvisoryTopic(dest);
            this.consumersLock.writeLock().lock();
            try {
                this.consumers.remove(info.getConsumerId());
                if (this.getBrokerService().isUseVirtualDestSubs()) {
                    this.fireVirtualDestinationRemoveAdvisory(context, info);
                }
            }
            finally {
                this.consumersLock.writeLock().unlock();
            }
            if (!dest.isTemporary() || this.destinations.containsKey(dest)) {
                this.fireConsumerAdvisory(context, dest, topic, info.createRemoveCommand());
            }
        }
    }

    @Override
    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        SubscriptionKey key = new SubscriptionKey(context.getClientId(), info.getSubscriptionName());
        RegionBroker regionBroker = null;
        if (this.next instanceof RegionBroker) {
            regionBroker = (RegionBroker)this.next;
        } else {
            BrokerService service = this.next.getBrokerService();
            regionBroker = (RegionBroker)service.getRegionBroker();
        }
        if (regionBroker == null) {
            LOG.warn("Cannot locate a RegionBroker instance to pass along the removeSubscription call");
            throw new IllegalStateException("No RegionBroker found.");
        }
        DurableTopicSubscription sub = ((TopicRegion)regionBroker.getTopicRegion()).getDurableSubscription(key);
        super.removeSubscription(context, info);
        if (sub == null) {
            LOG.warn("We cannot send an advisory message for a durable sub removal when we don't know about the durable sub");
            return;
        }
        PMQDestination dest = sub.getConsumerInfo().getDestination();
        if (!AdvisorySupport.isAdvisoryTopic(dest)) {
            PMQTopic topic = AdvisorySupport.getConsumerAdvisoryTopic(dest);
            this.fireConsumerAdvisory(context, dest, topic, info);
        }
    }

    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.removeProducer(context, info);
        PMQDestination dest = info.getDestination();
        if ((dest != null || this.getBrokerService().isAnonymousProducerAdvisorySupport()) && !AdvisorySupport.isAdvisoryTopic(dest)) {
            PMQTopic topic = AdvisorySupport.getProducerAdvisoryTopic(dest);
            this.producers.remove(info.getProducerId());
            if (dest == null || !dest.isTemporary() || this.destinations.containsKey(dest)) {
                this.fireProducerAdvisory(context, dest, topic, info.createRemoveCommand());
            }
        }
    }

    @Override
    public void messageExpired(ConnectionContext context, MessageReference messageReference, Subscription subscription) {
        super.messageExpired(context, messageReference, subscription);
        try {
            if (!messageReference.isAdvisory()) {
                BaseDestination baseDestination = (BaseDestination)messageReference.getMessage().getRegionDestination();
                PMQTopic topic = AdvisorySupport.getExpiredMessageTopic(baseDestination.getPMQDestination());
                Message payload = messageReference.getMessage().copy();
                if (!baseDestination.isIncludeBodyForAdvisory()) {
                    payload.clearBody();
                }
                PMQMessage advisoryMessage = new PMQMessage();
                advisoryMessage.setStringProperty("orignalMessageId", payload.getMessageId().toString());
                this.fireAdvisory(context, topic, payload, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("expired", e);
        }
    }

    @Override
    public void messageConsumed(ConnectionContext context, MessageReference messageReference) {
        super.messageConsumed(context, messageReference);
        try {
            if (!messageReference.isAdvisory()) {
                BaseDestination baseDestination = (BaseDestination)messageReference.getMessage().getRegionDestination();
                PMQTopic topic = AdvisorySupport.getMessageConsumedAdvisoryTopic(baseDestination.getPMQDestination());
                Message payload = messageReference.getMessage().copy();
                if (!baseDestination.isIncludeBodyForAdvisory()) {
                    payload.clearBody();
                }
                PMQMessage advisoryMessage = new PMQMessage();
                advisoryMessage.setStringProperty("orignalMessageId", payload.getMessageId().toString());
                advisoryMessage.setStringProperty("orignalDestination", baseDestination.getPMQDestination().getQualifiedName());
                this.fireAdvisory(context, topic, payload, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("consumed", e);
        }
    }

    @Override
    public void messageDelivered(ConnectionContext context, MessageReference messageReference) {
        super.messageDelivered(context, messageReference);
        try {
            if (!messageReference.isAdvisory()) {
                BaseDestination baseDestination = (BaseDestination)messageReference.getMessage().getRegionDestination();
                PMQTopic topic = AdvisorySupport.getMessageDeliveredAdvisoryTopic(baseDestination.getPMQDestination());
                Message payload = messageReference.getMessage().copy();
                if (!baseDestination.isIncludeBodyForAdvisory()) {
                    payload.clearBody();
                }
                PMQMessage advisoryMessage = new PMQMessage();
                advisoryMessage.setStringProperty("orignalMessageId", payload.getMessageId().toString());
                advisoryMessage.setStringProperty("orignalDestination", baseDestination.getPMQDestination().getQualifiedName());
                this.fireAdvisory(context, topic, payload, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("delivered", e);
        }
    }

    @Override
    public void messageDiscarded(ConnectionContext context, Subscription sub, MessageReference messageReference) {
        super.messageDiscarded(context, sub, messageReference);
        try {
            if (!messageReference.isAdvisory()) {
                BaseDestination baseDestination = (BaseDestination)messageReference.getMessage().getRegionDestination();
                PMQTopic topic = AdvisorySupport.getMessageDiscardedAdvisoryTopic(baseDestination.getPMQDestination());
                Message payload = messageReference.getMessage().copy();
                if (!baseDestination.isIncludeBodyForAdvisory()) {
                    payload.clearBody();
                }
                PMQMessage advisoryMessage = new PMQMessage();
                if (sub instanceof TopicSubscription) {
                    advisoryMessage.setIntProperty("discardedCount", ((TopicSubscription)sub).discarded());
                }
                advisoryMessage.setStringProperty("orignalMessageId", payload.getMessageId().toString());
                advisoryMessage.setStringProperty("consumerId", sub.getConsumerInfo().getConsumerId().toString());
                advisoryMessage.setStringProperty("orignalDestination", baseDestination.getPMQDestination().getQualifiedName());
                this.fireAdvisory(context, topic, payload, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("discarded", e);
        }
    }

    @Override
    public void slowConsumer(ConnectionContext context, Destination destination, Subscription subs) {
        super.slowConsumer(context, destination, subs);
        try {
            if (!AdvisorySupport.isAdvisoryTopic(destination.getPMQDestination())) {
                PMQTopic topic = AdvisorySupport.getSlowConsumerAdvisoryTopic(destination.getPMQDestination());
                PMQMessage advisoryMessage = new PMQMessage();
                advisoryMessage.setStringProperty("consumerId", subs.getConsumerInfo().getConsumerId().toString());
                this.fireAdvisory(context, topic, subs.getConsumerInfo(), null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("slow consumer", e);
        }
    }

    @Override
    public void fastProducer(ConnectionContext context, ProducerInfo producerInfo, PMQDestination destination) {
        super.fastProducer(context, producerInfo, destination);
        try {
            if (!AdvisorySupport.isAdvisoryTopic(destination)) {
                PMQTopic topic = AdvisorySupport.getFastProducerAdvisoryTopic(destination);
                PMQMessage advisoryMessage = new PMQMessage();
                advisoryMessage.setStringProperty("producerId", producerInfo.getProducerId().toString());
                this.fireAdvisory(context, topic, producerInfo, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("fast producer", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void virtualDestinationAdded(ConnectionContext context, VirtualDestination virtualDestination) {
        block9: {
            super.virtualDestinationAdded(context, virtualDestination);
            if (this.virtualDestinations.add(virtualDestination)) {
                LOG.debug("Virtual destination added: {}", (Object)virtualDestination);
                try {
                    if (AdvisorySupport.isAdvisoryTopic(virtualDestination.getVirtualDestination())) break block9;
                    this.consumersLock.readLock().lock();
                    try {
                        if (this.getBrokerService().isUseVirtualDestSubsOnCreation()) {
                            for (PMQDestination destination : this.destinations.keySet()) {
                                if (!destination.isQueue() || !this.virtualDestinationMatcher.matches(virtualDestination, destination)) continue;
                                this.fireVirtualDestinationAddAdvisory(context, null, destination, virtualDestination);
                            }
                        }
                        for (ConsumerInfo info : this.consumers.values()) {
                            if (!this.virtualDestinationMatcher.matches(virtualDestination, info.getDestination())) continue;
                            this.fireVirtualDestinationAddAdvisory(context, info, info.getDestination(), virtualDestination);
                        }
                    }
                    finally {
                        this.consumersLock.readLock().unlock();
                    }
                }
                catch (Exception e) {
                    this.handleFireFailure("virtualDestinationAdded", e);
                }
            }
        }
    }

    private void fireVirtualDestinationAddAdvisory(ConnectionContext context, ConsumerInfo info, PMQDestination pmqDest, VirtualDestination virtualDestination) throws Exception {
        if (info == null) {
            ConnectionId connectionId;
            SessionId sessionId;
            ConsumerId consumerId;
            VirtualConsumerPair pair = new VirtualConsumerPair(virtualDestination, pmqDest);
            if (this.brokerConsumerDests.get(pair) == null && this.brokerConsumerDests.putIfAbsent(pair, info = new ConsumerInfo(consumerId = new ConsumerId(sessionId = new SessionId(connectionId = new ConnectionId(this.connectionIdGenerator.generateId()), this.sessionIdGenerator.getNextSequenceId()), this.consumerIdGenerator.getNextSequenceId()))) == null) {
                LOG.debug("Virtual consumer pair added: {} for consumer: {} ", (Object)pair, (Object)info);
                this.setConsumerInfoVirtualDest(info, virtualDestination, pmqDest);
                PMQTopic topic = AdvisorySupport.getVirtualDestinationConsumerAdvisoryTopic(info.getDestination());
                if (this.virtualDestinationConsumers.putIfAbsent(info, virtualDestination) == null) {
                    LOG.debug("Virtual consumer added: {}, for virtual destination: {}", (Object)info, (Object)virtualDestination);
                    this.fireConsumerAdvisory(context, info.getDestination(), topic, info);
                }
            }
        } else {
            info = info.copy();
            this.setConsumerInfoVirtualDest(info, virtualDestination, pmqDest);
            PMQTopic topic = AdvisorySupport.getVirtualDestinationConsumerAdvisoryTopic(info.getDestination());
            if (this.virtualDestinationConsumers.putIfAbsent(info, virtualDestination) == null) {
                LOG.debug("Virtual consumer added: {}, for virtual destination: {}", (Object)info, (Object)virtualDestination);
                this.fireConsumerAdvisory(context, info.getDestination(), topic, info);
            }
        }
    }

    private void setConsumerInfoVirtualDest(ConsumerInfo info, VirtualDestination virtualDestination, PMQDestination pmqDest) {
        info.setDestination(virtualDestination.getVirtualDestination());
        if (virtualDestination instanceof VirtualTopic) {
            String[] postfixPaths;
            String postfix;
            VirtualTopic vt = (VirtualTopic)virtualDestination;
            String prefix = vt.getPrefix() != null ? vt.getPrefix() : "";
            String string = postfix = vt.getPostfix() != null ? vt.getPostfix() : "";
            if (prefix.endsWith(".")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            if (postfix.startsWith(".")) {
                postfix = postfix.substring(1, postfix.length());
            }
            PMQTopic prefixDestination = prefix.length() > 0 ? new PMQTopic(prefix) : null;
            PMQTopic postfixDestination = postfix.length() > 0 ? new PMQTopic(postfix) : null;
            String[] prefixPaths = prefixDestination != null ? prefixDestination.getDestinationPaths() : new String[]{};
            String[] pmqDestPaths = pmqDest.getDestinationPaths();
            String[] stringArray = postfixPaths = postfixDestination != null ? postfixDestination.getDestinationPaths() : new String[]{};
            if (pmqDestPaths.length > prefixPaths.length + postfixPaths.length) {
                String[] topicPath = Arrays.copyOfRange(pmqDestPaths, 0 + prefixPaths.length, pmqDestPaths.length - postfixPaths.length);
                PMQTopic newTopic = new PMQTopic(DestinationPath.toString(topicPath));
                info.setDestination(newTopic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void virtualDestinationRemoved(ConnectionContext context, VirtualDestination virtualDestination) {
        super.virtualDestinationRemoved(context, virtualDestination);
        if (this.virtualDestinations.remove(virtualDestination)) {
            LOG.debug("Virtual destination removed: {}", (Object)virtualDestination);
            try {
                this.consumersLock.readLock().lock();
                try {
                    if (this.getBrokerService().isUseVirtualDestSubsOnCreation() && !AdvisorySupport.isAdvisoryTopic(virtualDestination.getVirtualDestination())) {
                        for (ConsumerInfo info : this.virtualDestinationConsumers.keySet()) {
                            if (!((VirtualDestination)this.virtualDestinationConsumers.get(info)).equals(virtualDestination)) continue;
                            this.fireVirtualDestinationRemoveAdvisory(context, info);
                            for (VirtualConsumerPair pmqDest : this.brokerConsumerDests.keySet()) {
                                ConsumerInfo i = (ConsumerInfo)this.brokerConsumerDests.get(pmqDest);
                                if (!info.equals(i) || this.brokerConsumerDests.remove(pmqDest) == null) continue;
                                LOG.debug("Virtual consumer pair removed: {} for consumer: {} ", (Object)pmqDest, (Object)i);
                            }
                        }
                    }
                }
                finally {
                    this.consumersLock.readLock().unlock();
                }
            }
            catch (Exception e) {
                this.handleFireFailure("virtualDestinationAdded", e);
            }
        }
    }

    private void fireVirtualDestinationRemoveAdvisory(ConnectionContext context, ConsumerInfo info) throws Exception {
        VirtualDestination virtualDestination = (VirtualDestination)this.virtualDestinationConsumers.remove(info);
        if (virtualDestination != null) {
            LOG.debug("Virtual consumer removed: {}, for virtual destination: {}", (Object)info, (Object)virtualDestination);
            PMQTopic topic = AdvisorySupport.getVirtualDestinationConsumerAdvisoryTopic(virtualDestination.getVirtualDestination());
            PMQDestination dest = info.getDestination();
            if (!dest.isTemporary() || this.destinations.containsKey(dest)) {
                this.fireConsumerAdvisory(context, dest, topic, info.createRemoveCommand());
            }
        }
    }

    @Override
    public void isFull(ConnectionContext context, Destination destination, Usage<?> usage) {
        super.isFull(context, destination, usage);
        if (!AdvisorySupport.isAdvisoryTopic(destination.getPMQDestination())) {
            try {
                PMQTopic topic = AdvisorySupport.getFullAdvisoryTopic(destination.getPMQDestination());
                PMQMessage advisoryMessage = new PMQMessage();
                advisoryMessage.setStringProperty("usageName", usage.getName());
                advisoryMessage.setLongProperty("usageCount", usage.getUsage());
                this.fireAdvisory(context, topic, null, null, advisoryMessage);
            }
            catch (Exception e) {
                this.handleFireFailure("is full", e);
            }
        }
    }

    @Override
    public void nowMasterBroker() {
        super.nowMasterBroker();
        try {
            PMQTopic topic = AdvisorySupport.getMasterBrokerAdvisoryTopic();
            PMQMessage advisoryMessage = new PMQMessage();
            ConnectionContext context = new ConnectionContext();
            context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
            context.setBroker(this.getBrokerService().getBroker());
            this.fireAdvisory(context, topic, null, null, advisoryMessage);
        }
        catch (Exception e) {
            this.handleFireFailure("now master broker", e);
        }
    }

    @Override
    public boolean sendToDeadLetterQueue(ConnectionContext context, MessageReference messageReference, Subscription subscription, Throwable poisonCause) {
        boolean wasDLQd = super.sendToDeadLetterQueue(context, messageReference, subscription, poisonCause);
        if (wasDLQd) {
            try {
                if (!messageReference.isAdvisory()) {
                    BaseDestination baseDestination = (BaseDestination)messageReference.getMessage().getRegionDestination();
                    PMQTopic topic = AdvisorySupport.getMessageDLQdAdvisoryTopic(baseDestination.getPMQDestination());
                    Message payload = messageReference.getMessage().copy();
                    if (!baseDestination.isIncludeBodyForAdvisory()) {
                        payload.clearBody();
                    }
                    this.fireAdvisory(context, topic, payload);
                }
            }
            catch (Exception e) {
                this.handleFireFailure("add to DLQ", e);
            }
        }
        return wasDLQd;
    }

    @Override
    public void networkBridgeStarted(BrokerInfo brokerInfo, boolean createdByDuplex, String remoteIp) {
        try {
            if (brokerInfo != null) {
                PMQMessage advisoryMessage = new PMQMessage();
                advisoryMessage.setBooleanProperty("started", true);
                advisoryMessage.setBooleanProperty("createdByDuplex", createdByDuplex);
                advisoryMessage.setStringProperty("remoteIp", remoteIp);
                this.networkBridges.putIfAbsent(brokerInfo, advisoryMessage);
                PMQTopic topic = AdvisorySupport.getNetworkBridgeAdvisoryTopic();
                ConnectionContext context = new ConnectionContext();
                context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
                context.setBroker(this.getBrokerService().getBroker());
                this.fireAdvisory(context, topic, brokerInfo, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("network bridge started", e);
        }
    }

    @Override
    public void networkBridgeStopped(BrokerInfo brokerInfo) {
        try {
            if (brokerInfo != null) {
                PMQMessage advisoryMessage = new PMQMessage();
                advisoryMessage.setBooleanProperty("started", false);
                this.networkBridges.remove(brokerInfo);
                PMQTopic topic = AdvisorySupport.getNetworkBridgeAdvisoryTopic();
                ConnectionContext context = new ConnectionContext();
                context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
                context.setBroker(this.getBrokerService().getBroker());
                this.fireAdvisory(context, topic, brokerInfo, null, advisoryMessage);
            }
        }
        catch (Exception e) {
            this.handleFireFailure("network bridge stopped", e);
        }
    }

    private void handleFireFailure(String message, Throwable cause) {
        LOG.warn("Failed to fire {} advisory, reason: {}", (Object)message, (Object)cause);
        LOG.debug("{} detail: {}", message, cause, cause);
    }

    protected void fireAdvisory(ConnectionContext context, PMQTopic topic, Command command) throws Exception {
        this.fireAdvisory(context, topic, command, null);
    }

    protected void fireAdvisory(ConnectionContext context, PMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        PMQMessage advisoryMessage = new PMQMessage();
        this.fireAdvisory(context, topic, command, targetConsumerId, advisoryMessage);
    }

    protected void fireConsumerAdvisory(ConnectionContext context, PMQDestination consumerDestination, PMQTopic topic, Command command) throws Exception {
        this.fireConsumerAdvisory(context, consumerDestination, topic, command, null);
    }

    protected void fireConsumerAdvisory(ConnectionContext context, PMQDestination consumerDestination, PMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        PMQMessage advisoryMessage = new PMQMessage();
        int count = 0;
        Set<Destination> set = this.getDestinations(consumerDestination);
        if (set != null) {
            for (Destination dest : set) {
                count = (int)((long)count + dest.getDestinationStatistics().getConsumers().getCount());
            }
        }
        advisoryMessage.setIntProperty("consumerCount", count);
        this.fireAdvisory(context, topic, command, targetConsumerId, advisoryMessage);
    }

    protected void fireProducerAdvisory(ConnectionContext context, PMQDestination producerDestination, PMQTopic topic, Command command) throws Exception {
        this.fireProducerAdvisory(context, producerDestination, topic, command, null);
    }

    protected void fireProducerAdvisory(ConnectionContext context, PMQDestination producerDestination, PMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        Set<Destination> set;
        PMQMessage advisoryMessage = new PMQMessage();
        int count = 0;
        if (producerDestination != null && (set = this.getDestinations(producerDestination)) != null) {
            for (Destination dest : set) {
                count = (int)((long)count + dest.getDestinationStatistics().getProducers().getCount());
            }
        }
        advisoryMessage.setIntProperty("producerCount", count);
        this.fireAdvisory(context, topic, command, targetConsumerId, advisoryMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAdvisory(ConnectionContext context, PMQTopic topic, Command command, ConsumerId targetConsumerId, PMQMessage advisoryMessage) throws Exception {
        advisoryMessage.setStringProperty("originBrokerName", this.getBrokerName());
        String id = this.getBrokerId() != null ? this.getBrokerId().getValue() : "NOT_SET";
        advisoryMessage.setStringProperty("originBrokerId", id);
        String url = this.getBrokerService().getVmConnectorURI().toString();
        if (context.getConnector() instanceof TransportConnector && ((TransportConnector)context.getConnector()).getPublishableConnectString() != null) {
            url = ((TransportConnector)context.getConnector()).getPublishableConnectString();
        } else if (this.getBrokerService().getDefaultSocketURIString() != null) {
            url = this.getBrokerService().getDefaultSocketURIString();
        }
        advisoryMessage.setStringProperty("originBrokerURL", url);
        advisoryMessage.setDataStructure(command);
        advisoryMessage.setPersistent(false);
        advisoryMessage.setType("Advisory");
        advisoryMessage.setMessageId(new MessageId(this.advisoryProducerId, this.messageIdGenerator.getNextSequenceId()));
        advisoryMessage.setTargetConsumerId(targetConsumerId);
        advisoryMessage.setDestination(topic);
        advisoryMessage.setResponseRequired(false);
        advisoryMessage.setProducerId(this.advisoryProducerId);
        boolean originalFlowControl = context.isProducerFlowControl();
        ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
        producerExchange.setConnectionContext(context);
        producerExchange.setMutable(true);
        producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
        try {
            context.setProducerFlowControl(false);
            this.next.send(producerExchange, advisoryMessage);
        }
        finally {
            context.setProducerFlowControl(originalFlowControl);
        }
    }

    public Map<ConnectionId, ConnectionInfo> getAdvisoryConnections() {
        return this.connections;
    }

    public Collection<ConsumerInfo> getAdvisoryConsumers() {
        this.consumersLock.readLock().lock();
        try {
            ArrayList<ConsumerInfo> arrayList = new ArrayList<ConsumerInfo>(this.consumers.values());
            return arrayList;
        }
        finally {
            this.consumersLock.readLock().unlock();
        }
    }

    public Map<ProducerId, ProducerInfo> getAdvisoryProducers() {
        return this.producers;
    }

    public Map<PMQDestination, DestinationInfo> getAdvisoryDestinations() {
        return this.destinations;
    }

    public ConcurrentMap<ConsumerInfo, VirtualDestination> getVirtualDestinationConsumers() {
        return this.virtualDestinationConsumers;
    }

    private class VirtualConsumerPair {
        private final VirtualDestination virtualDestination;
        private final PMQDestination pmqDestination;

        public VirtualConsumerPair(VirtualDestination virtualDestination, PMQDestination pmqDestination) {
            this.virtualDestination = virtualDestination;
            this.pmqDestination = pmqDestination;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.pmqDestination == null ? 0 : this.pmqDestination.hashCode());
            result = 31 * result + (this.virtualDestination == null ? 0 : this.virtualDestination.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualConsumerPair other = (VirtualConsumerPair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.pmqDestination == null ? other.pmqDestination != null : !this.pmqDestination.equals(other.pmqDestination)) {
                return false;
            }
            return !(this.virtualDestination == null ? other.virtualDestination != null : !this.virtualDestination.equals(other.virtualDestination));
        }

        public String toString() {
            return "VirtualConsumerPair [virtualDestination=" + this.virtualDestination + ", pmqDestination=" + this.pmqDestination + "]";
        }

        private AdvisoryBroker getOuterType() {
            return AdvisoryBroker.this;
        }
    }
}

