/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.advisory;

import com.primeton.pmq.PMQMessageTransformation;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQTopic;
import java.util.ArrayList;
import javax.jms.Destination;
import javax.jms.JMSException;

public final class AdvisorySupport {
    public static final String ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.";
    public static final PMQTopic CONNECTION_ADVISORY_TOPIC = new PMQTopic("PMQ.Advisory.Connection");
    public static final PMQTopic QUEUE_ADVISORY_TOPIC = new PMQTopic("PMQ.Advisory.Queue");
    public static final PMQTopic TOPIC_ADVISORY_TOPIC = new PMQTopic("PMQ.Advisory.Topic");
    public static final PMQTopic TEMP_QUEUE_ADVISORY_TOPIC = new PMQTopic("PMQ.Advisory.TempQueue");
    public static final PMQTopic TEMP_TOPIC_ADVISORY_TOPIC = new PMQTopic("PMQ.Advisory.TempTopic");
    public static final String PRODUCER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.Producer.";
    public static final String QUEUE_PRODUCER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.Producer.Queue.";
    public static final String TOPIC_PRODUCER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.Producer.Topic.";
    public static final String ANONYMOUS_PRODUCER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.Producer.Anonymous";
    public static final String CONSUMER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.Consumer.";
    public static final String VIRTUAL_DESTINATION_CONSUMER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.VirtualDestination.Consumer.";
    public static final String QUEUE_CONSUMER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.Consumer.Queue.";
    public static final String TOPIC_CONSUMER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.Consumer.Topic.";
    public static final String QUEUE_VIRTUAL_DESTINATION_CONSUMER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.VirtualDestination.Consumer.Queue.";
    public static final String TOPIC_VIRTUAL_DESTINATION_CONSUMER_ADVISORY_TOPIC_PREFIX = "PMQ.Advisory.VirtualDestination.Consumer.Topic.";
    public static final String EXPIRED_TOPIC_MESSAGES_TOPIC_PREFIX = "PMQ.Advisory.Expired.Topic.";
    public static final String EXPIRED_QUEUE_MESSAGES_TOPIC_PREFIX = "PMQ.Advisory.Expired.Queue.";
    public static final String NO_TOPIC_CONSUMERS_TOPIC_PREFIX = "PMQ.Advisory.NoConsumer.Topic.";
    public static final String NO_QUEUE_CONSUMERS_TOPIC_PREFIX = "PMQ.Advisory.NoConsumer.Queue.";
    public static final String SLOW_CONSUMER_TOPIC_PREFIX = "PMQ.Advisory.SlowConsumer.";
    public static final String FAST_PRODUCER_TOPIC_PREFIX = "PMQ.Advisory.FastProducer.";
    public static final String MESSAGE_DISCAREDED_TOPIC_PREFIX = "PMQ.Advisory.MessageDiscarded.";
    public static final String FULL_TOPIC_PREFIX = "PMQ.Advisory.FULL.";
    public static final String MESSAGE_DELIVERED_TOPIC_PREFIX = "PMQ.Advisory.MessageDelivered.";
    public static final String MESSAGE_CONSUMED_TOPIC_PREFIX = "PMQ.Advisory.MessageConsumed.";
    public static final String MESSAGE_DLQ_TOPIC_PREFIX = "PMQ.Advisory.MessageDLQd.";
    public static final String MASTER_BROKER_TOPIC_PREFIX = "PMQ.Advisory.MasterBroker";
    public static final String NETWORK_BRIDGE_TOPIC_PREFIX = "PMQ.Advisory.NetworkBridge";
    public static final String NETWORK_BRIDGE_FORWARD_FAILURE_TOPIC_PREFIX = "PMQ.Advisory.NetworkBridge.ForwardFailure";
    public static final String AGENT_TOPIC = "PMQ.Agent";
    public static final String ADIVSORY_MESSAGE_TYPE = "Advisory";
    public static final String MSG_PROPERTY_ORIGIN_BROKER_ID = "originBrokerId";
    public static final String MSG_PROPERTY_ORIGIN_BROKER_NAME = "originBrokerName";
    public static final String MSG_PROPERTY_ORIGIN_BROKER_URL = "originBrokerURL";
    public static final String MSG_PROPERTY_USAGE_NAME = "usageName";
    public static final String MSG_PROPERTY_USAGE_COUNT = "usageCount";
    public static final String MSG_PROPERTY_CONSUMER_ID = "consumerId";
    public static final String MSG_PROPERTY_PRODUCER_ID = "producerId";
    public static final String MSG_PROPERTY_MESSAGE_ID = "orignalMessageId";
    public static final String MSG_PROPERTY_DESTINATION = "orignalDestination";
    public static final String MSG_PROPERTY_CONSUMER_COUNT = "consumerCount";
    public static final String MSG_PROPERTY_DISCARDED_COUNT = "discardedCount";
    public static final PMQTopic ALL_DESTINATIONS_COMPOSITE_ADVISORY_TOPIC = new PMQTopic(TOPIC_ADVISORY_TOPIC.getPhysicalName() + "," + QUEUE_ADVISORY_TOPIC.getPhysicalName() + "," + TEMP_QUEUE_ADVISORY_TOPIC.getPhysicalName() + "," + TEMP_TOPIC_ADVISORY_TOPIC.getPhysicalName());
    public static final PMQTopic TEMP_DESTINATION_COMPOSITE_ADVISORY_TOPIC = new PMQTopic(TEMP_QUEUE_ADVISORY_TOPIC.getPhysicalName() + "," + TEMP_TOPIC_ADVISORY_TOPIC.getPhysicalName());
    private static final PMQTopic AGENT_TOPIC_DESTINATION = new PMQTopic("PMQ.Agent");

    private AdvisorySupport() {
    }

    public static PMQTopic getConnectionAdvisoryTopic() {
        return CONNECTION_ADVISORY_TOPIC;
    }

    public static PMQTopic[] getAllDestinationAdvisoryTopics(Destination destination) throws JMSException {
        return AdvisorySupport.getAllDestinationAdvisoryTopics(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic[] getAllDestinationAdvisoryTopics(PMQDestination destination) throws JMSException {
        ArrayList<PMQTopic> result = new ArrayList<PMQTopic>();
        result.add(AdvisorySupport.getConsumerAdvisoryTopic(destination));
        result.add(AdvisorySupport.getProducerAdvisoryTopic(destination));
        result.add(AdvisorySupport.getExpiredMessageTopic(destination));
        result.add(AdvisorySupport.getNoConsumersAdvisoryTopic(destination));
        result.add(AdvisorySupport.getSlowConsumerAdvisoryTopic(destination));
        result.add(AdvisorySupport.getFastProducerAdvisoryTopic(destination));
        result.add(AdvisorySupport.getMessageDiscardedAdvisoryTopic(destination));
        result.add(AdvisorySupport.getMessageDeliveredAdvisoryTopic(destination));
        result.add(AdvisorySupport.getMessageConsumedAdvisoryTopic(destination));
        result.add(AdvisorySupport.getMessageDLQdAdvisoryTopic(destination));
        result.add(AdvisorySupport.getFullAdvisoryTopic(destination));
        return result.toArray(new PMQTopic[0]);
    }

    public static PMQTopic getConsumerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getConsumerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getConsumerAdvisoryTopic(PMQDestination destination) {
        String prefix = destination.isQueue() ? QUEUE_CONSUMER_ADVISORY_TOPIC_PREFIX : TOPIC_CONSUMER_ADVISORY_TOPIC_PREFIX;
        return AdvisorySupport.getAdvisoryTopic(destination, prefix, true);
    }

    public static PMQTopic getVirtualDestinationConsumerAdvisoryTopic(PMQDestination destination) {
        String prefix = destination.isQueue() ? QUEUE_VIRTUAL_DESTINATION_CONSUMER_ADVISORY_TOPIC_PREFIX : TOPIC_VIRTUAL_DESTINATION_CONSUMER_ADVISORY_TOPIC_PREFIX;
        return AdvisorySupport.getAdvisoryTopic(destination, prefix, true);
    }

    public static PMQTopic getProducerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getProducerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getProducerAdvisoryTopic(PMQDestination destination) {
        String prefix = destination == null ? ANONYMOUS_PRODUCER_ADVISORY_TOPIC_PREFIX : (destination.isQueue() ? QUEUE_PRODUCER_ADVISORY_TOPIC_PREFIX : TOPIC_PRODUCER_ADVISORY_TOPIC_PREFIX);
        return AdvisorySupport.getAdvisoryTopic(destination, prefix, false);
    }

    private static PMQTopic getAdvisoryTopic(PMQDestination destination, String prefix, boolean consumerTopics) {
        return destination != null ? new PMQTopic(prefix + destination.getPhysicalName().replaceAll(",", "&sbquo;")) : new PMQTopic(prefix);
    }

    public static PMQTopic getExpiredMessageTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getExpiredMessageTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getExpiredMessageTopic(PMQDestination destination) {
        if (destination.isQueue()) {
            return AdvisorySupport.getExpiredQueueMessageAdvisoryTopic(destination);
        }
        return AdvisorySupport.getExpiredTopicMessageAdvisoryTopic(destination);
    }

    public static PMQTopic getExpiredTopicMessageAdvisoryTopic(PMQDestination destination) {
        String name = EXPIRED_TOPIC_MESSAGES_TOPIC_PREFIX + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getExpiredQueueMessageAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getExpiredQueueMessageAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getExpiredQueueMessageAdvisoryTopic(PMQDestination destination) {
        String name = EXPIRED_QUEUE_MESSAGES_TOPIC_PREFIX + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getNoConsumersAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getExpiredMessageTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getNoConsumersAdvisoryTopic(PMQDestination destination) {
        if (destination.isQueue()) {
            return AdvisorySupport.getNoQueueConsumersAdvisoryTopic(destination);
        }
        return AdvisorySupport.getNoTopicConsumersAdvisoryTopic(destination);
    }

    public static PMQTopic getNoTopicConsumersAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getNoTopicConsumersAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getNoTopicConsumersAdvisoryTopic(PMQDestination destination) {
        String name = NO_TOPIC_CONSUMERS_TOPIC_PREFIX + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getNoQueueConsumersAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getNoQueueConsumersAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getNoQueueConsumersAdvisoryTopic(PMQDestination destination) {
        String name = NO_QUEUE_CONSUMERS_TOPIC_PREFIX + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getSlowConsumerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getSlowConsumerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getSlowConsumerAdvisoryTopic(PMQDestination destination) {
        String name = SLOW_CONSUMER_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getFastProducerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getFastProducerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getFastProducerAdvisoryTopic(PMQDestination destination) {
        String name = FAST_PRODUCER_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getMessageDiscardedAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getMessageDiscardedAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getMessageDiscardedAdvisoryTopic(PMQDestination destination) {
        String name = MESSAGE_DISCAREDED_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getMessageDeliveredAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getMessageDeliveredAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getMessageDeliveredAdvisoryTopic(PMQDestination destination) {
        String name = MESSAGE_DELIVERED_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getMessageConsumedAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getMessageConsumedAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getMessageConsumedAdvisoryTopic(PMQDestination destination) {
        String name = MESSAGE_CONSUMED_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getMessageDLQdAdvisoryTopic(PMQDestination destination) {
        String name = MESSAGE_DLQ_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getMasterBrokerAdvisoryTopic() {
        return new PMQTopic(MASTER_BROKER_TOPIC_PREFIX);
    }

    public static PMQTopic getNetworkBridgeAdvisoryTopic() {
        return new PMQTopic(NETWORK_BRIDGE_TOPIC_PREFIX);
    }

    public static PMQTopic getFullAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getFullAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getFullAdvisoryTopic(PMQDestination destination) {
        String name = FULL_TOPIC_PREFIX + destination.getDestinationTypeAsString() + "." + destination.getPhysicalName();
        return new PMQTopic(name);
    }

    public static PMQTopic getDestinationAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.getDestinationAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static PMQTopic getDestinationAdvisoryTopic(PMQDestination destination) {
        switch (destination.getDestinationType()) {
            case 1: {
                return QUEUE_ADVISORY_TOPIC;
            }
            case 2: {
                return TOPIC_ADVISORY_TOPIC;
            }
            case 5: {
                return TEMP_QUEUE_ADVISORY_TOPIC;
            }
            case 6: {
                return TEMP_TOPIC_ADVISORY_TOPIC;
            }
        }
        throw new RuntimeException("Unknown destination type: " + destination.getDestinationType());
    }

    public static boolean isDestinationAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isDestinationAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isTempDestinationAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (AdvisorySupport.isTempDestinationAdvisoryTopic(compositeDestinations[i])) continue;
                return false;
            }
            return true;
        }
        return destination.equals(TEMP_QUEUE_ADVISORY_TOPIC) || destination.equals(TEMP_TOPIC_ADVISORY_TOPIC);
    }

    public static boolean isDestinationAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isDestinationAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.equals(TEMP_QUEUE_ADVISORY_TOPIC) || destination.equals(TEMP_TOPIC_ADVISORY_TOPIC) || destination.equals(QUEUE_ADVISORY_TOPIC) || destination.equals(TOPIC_ADVISORY_TOPIC);
    }

    public static boolean isAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isAdvisoryTopic(PMQDestination destination) {
        if (destination != null) {
            if (destination.isComposite()) {
                PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
                for (int i = 0; i < compositeDestinations.length; ++i) {
                    if (!AdvisorySupport.isAdvisoryTopic(compositeDestinations[i])) continue;
                    return true;
                }
                return false;
            }
            return destination.isTopic() && destination.getPhysicalName().startsWith(ADVISORY_TOPIC_PREFIX);
        }
        return false;
    }

    public static boolean isConnectionAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isConnectionAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isConnectionAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isConnectionAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.equals(CONNECTION_ADVISORY_TOPIC);
    }

    public static boolean isProducerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isProducerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isProducerAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isProducerAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(PRODUCER_ADVISORY_TOPIC_PREFIX);
    }

    public static boolean isConsumerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isConsumerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isConsumerAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isConsumerAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(CONSUMER_ADVISORY_TOPIC_PREFIX);
    }

    public static boolean isVirtualDestinationConsumerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isVirtualDestinationConsumerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isVirtualDestinationConsumerAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isVirtualDestinationConsumerAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(VIRTUAL_DESTINATION_CONSUMER_ADVISORY_TOPIC_PREFIX);
    }

    public static boolean isSlowConsumerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isSlowConsumerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isSlowConsumerAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isSlowConsumerAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(SLOW_CONSUMER_TOPIC_PREFIX);
    }

    public static boolean isFastProducerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isFastProducerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isFastProducerAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isFastProducerAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(FAST_PRODUCER_TOPIC_PREFIX);
    }

    public static boolean isMessageConsumedAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isMessageConsumedAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isMessageConsumedAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isMessageConsumedAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(MESSAGE_CONSUMED_TOPIC_PREFIX);
    }

    public static boolean isMasterBrokerAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isMasterBrokerAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isMasterBrokerAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isMasterBrokerAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(MASTER_BROKER_TOPIC_PREFIX);
    }

    public static boolean isMessageDeliveredAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isMessageDeliveredAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isMessageDeliveredAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isMessageDeliveredAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(MESSAGE_DELIVERED_TOPIC_PREFIX);
    }

    public static boolean isMessageDiscardedAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isMessageDiscardedAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isMessageDiscardedAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isMessageDiscardedAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(MESSAGE_DISCAREDED_TOPIC_PREFIX);
    }

    public static boolean isFullAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isFullAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isFullAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isFullAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(FULL_TOPIC_PREFIX);
    }

    public static boolean isNetworkBridgeAdvisoryTopic(Destination destination) throws JMSException {
        return AdvisorySupport.isNetworkBridgeAdvisoryTopic(PMQMessageTransformation.transformDestination(destination));
    }

    public static boolean isNetworkBridgeAdvisoryTopic(PMQDestination destination) {
        if (destination.isComposite()) {
            PMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isNetworkBridgeAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(NETWORK_BRIDGE_TOPIC_PREFIX);
    }

    public static Destination getAgentDestination() {
        return AGENT_TOPIC_DESTINATION;
    }

    public static PMQTopic getNetworkBridgeForwardFailureAdvisoryTopic() {
        return new PMQTopic(NETWORK_BRIDGE_FORWARD_FAILURE_TOPIC_PREFIX);
    }
}

