/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.blob;

import com.primeton.pmq.blob.BlobDownloadStrategy;
import com.primeton.pmq.blob.BlobTransferPolicy;
import com.primeton.pmq.blob.DefaultStrategy;
import com.primeton.pmq.command.PMQBlobMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.jms.JMSException;

public class DefaultBlobDownloadStrategy
extends DefaultStrategy
implements BlobDownloadStrategy {
    public DefaultBlobDownloadStrategy(BlobTransferPolicy transferPolicy) {
        super(transferPolicy);
    }

    @Override
    public InputStream getInputStream(PMQBlobMessage message) throws IOException, JMSException {
        URL value = message.getURL();
        if (value == null) {
            return null;
        }
        return value.openStream();
    }

    @Override
    public void deleteFile(PMQBlobMessage message) throws IOException, JMSException {
        URL url = this.createMessageURL(message);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        try {
            connection.connect();
        }
        catch (IOException e) {
            throw new IOException("DELETE failed on: " + url, e);
        }
        finally {
            connection.disconnect();
        }
        if (!this.isSuccessfulCode(connection.getResponseCode())) {
            throw new IOException("DELETE was not successful: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }
}

