/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.ProducerInfo;

public class CompositeDestinationBroker
extends BrokerFilter {
    public CompositeDestinationBroker(Broker next) {
        super(next);
    }

    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        PMQDestination destination = info.getDestination();
        if (destination != null && destination.isComposite()) {
            PMQDestination[] destinations = destination.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ProducerInfo copy = info.copy();
                copy.setDestination(destinations[i]);
                this.next.addProducer(context, copy);
            }
        } else {
            this.next.addProducer(context, info);
        }
    }

    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        PMQDestination destination = info.getDestination();
        if (destination != null && destination.isComposite()) {
            PMQDestination[] destinations = destination.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ProducerInfo copy = info.copy();
                copy.setDestination(destinations[i]);
                this.next.removeProducer(context, copy);
            }
        } else {
            this.next.removeProducer(context, info);
        }
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        PMQDestination destination = message.getDestination();
        if (destination.isComposite()) {
            PMQDestination[] destinations = destination.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                if (i != 0) {
                    message = message.copy();
                    message.setMemoryUsage(null);
                }
                message.setOriginalDestination(destination);
                message.setDestination(destinations[i]);
                this.next.send(producerExchange, message);
            }
        } else {
            this.next.send(producerExchange, message);
        }
    }
}

