/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.jmx;

import com.primeton.pmq.broker.jmx.NetworkBridgeViewMBean;
import com.primeton.pmq.broker.jmx.NetworkDestinationView;
import com.primeton.pmq.network.NetworkBridge;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NetworkBridgeView
implements NetworkBridgeViewMBean {
    private final NetworkBridge bridge;
    private boolean createByDuplex = false;
    private List<NetworkDestinationView> networkDestinationViewList = new CopyOnWriteArrayList<NetworkDestinationView>();

    public NetworkBridgeView(NetworkBridge bridge) {
        this.bridge = bridge;
    }

    @Override
    public void start() throws Exception {
        this.bridge.start();
    }

    @Override
    public void stop() throws Exception {
        this.bridge.stop();
    }

    @Override
    public String getLocalAddress() {
        return this.bridge.getLocalAddress();
    }

    @Override
    public String getRemoteAddress() {
        return this.bridge.getRemoteAddress();
    }

    @Override
    public String getRemoteBrokerName() {
        return this.bridge.getRemoteBrokerName();
    }

    @Override
    public String getRemoteBrokerId() {
        return this.bridge.getRemoteBrokerId();
    }

    @Override
    public String getLocalBrokerName() {
        return this.bridge.getLocalBrokerName();
    }

    @Override
    public long getEnqueueCounter() {
        return this.bridge.getEnqueueCounter();
    }

    @Override
    public long getDequeueCounter() {
        return this.bridge.getDequeueCounter();
    }

    @Override
    public long getReceivedCounter() {
        return this.bridge.getNetworkBridgeStatistics().getReceivedCount().getCount();
    }

    @Override
    public boolean isCreatedByDuplex() {
        return this.createByDuplex;
    }

    public void setCreateByDuplex(boolean createByDuplex) {
        this.createByDuplex = createByDuplex;
    }

    @Override
    public void resetStats() {
        this.bridge.resetStats();
        for (NetworkDestinationView networkDestinationView : this.networkDestinationViewList) {
            networkDestinationView.resetStats();
        }
    }

    public void addNetworkDestinationView(NetworkDestinationView networkDestinationView) {
        this.networkDestinationViewList.add(networkDestinationView);
    }

    public void removeNetworkDestinationView(NetworkDestinationView networkDestinationView) {
        this.networkDestinationViewList.remove(networkDestinationView);
    }
}

