/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region;

import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.policy.SimpleDispatchSelector;
import com.primeton.pmq.command.PMQDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueDispatchSelector
extends SimpleDispatchSelector {
    private static final Logger LOG = LoggerFactory.getLogger(QueueDispatchSelector.class);
    private Subscription exclusiveConsumer;
    private boolean paused;

    public QueueDispatchSelector(PMQDestination destination) {
        super(destination);
    }

    public Subscription getExclusiveConsumer() {
        return this.exclusiveConsumer;
    }

    public void setExclusiveConsumer(Subscription exclusiveConsumer) {
        this.exclusiveConsumer = exclusiveConsumer;
    }

    public boolean isExclusiveConsumer(Subscription s) {
        return s == this.exclusiveConsumer;
    }

    public boolean canSelect(Subscription subscription, MessageReference m) throws Exception {
        boolean result;
        boolean bl = result = !this.paused && super.canDispatch(subscription, m);
        if (result && !subscription.isBrowser()) {
            result = this.exclusiveConsumer == null || this.exclusiveConsumer == subscription;
        }
        return result;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

