/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.DestinationStatistics;
import com.primeton.pmq.broker.region.Queue;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.cursors.VMPendingMessageCursor;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQTempDestination;
import com.primeton.pmq.store.MessageStore;
import com.primeton.pmq.thread.TaskRunnerFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempQueue
extends Queue {
    private static final Logger LOG = LoggerFactory.getLogger(TempQueue.class);
    private final PMQTempDestination tempDest;

    public TempQueue(BrokerService brokerService, PMQDestination destination, MessageStore store2, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        super(brokerService, destination, store2, parentStats, taskFactory);
        this.tempDest = (PMQTempDestination)destination;
    }

    @Override
    public void initialize() throws Exception {
        this.messages = new VMPendingMessageCursor(false);
        this.messages.setMemoryUsageHighWaterMark(this.getCursorMemoryHighWaterMark());
        this.systemUsage = this.brokerService.getSystemUsage();
        this.memoryUsage.setParent(this.systemUsage.getMemoryUsage());
        this.taskRunner = this.taskFactory.createTaskRunner(this, "TempQueue:  " + this.destination.getPhysicalName());
    }

    @Override
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        if (!(context.isFaultTolerant() || context.isNetworkConnection() || this.tempDest.getConnectionId().equals(sub.getConsumerInfo().getConsumerId().getConnectionId()))) {
            this.tempDest.setConnectionId(sub.getConsumerInfo().getConsumerId().getConnectionId());
            LOG.debug("changed ownership of {} to {}", (Object)this, (Object)this.tempDest.getConnectionId());
        }
        super.addSubscription(context, sub);
    }

    @Override
    public void dispose(ConnectionContext context) throws IOException {
        if (this.destinationStatistics.getMessages().getCount() > 0L) {
            LOG.info("{} on dispose, purge of {} pending messages: {}", this.getPMQDestination().getQualifiedName(), this.destinationStatistics.getMessages().getCount(), this.messages);
        }
        try {
            this.purge();
        }
        catch (Exception e) {
            LOG.warn("Caught an exception purging Queue: {}", (Object)this.destination, (Object)e);
        }
        super.dispose(context);
    }
}

