/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.AbstractTempRegion;
import com.primeton.pmq.broker.region.DestinationFactory;
import com.primeton.pmq.broker.region.DestinationStatistics;
import com.primeton.pmq.broker.region.RegionBroker;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.TopicSubscription;
import com.primeton.pmq.broker.region.policy.PolicyEntry;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.thread.TaskRunnerFactory;
import com.primeton.pmq.usage.SystemUsage;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempTopicRegion
extends AbstractTempRegion {
    private static final Logger LOG = LoggerFactory.getLogger(TempTopicRegion.class);

    public TempTopicRegion(RegionBroker broker, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    @Override
    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        if (info.isDurable()) {
            throw new JMSException("A durable subscription cannot be created for a temporary topic.");
        }
        try {
            PolicyEntry entry;
            TopicSubscription answer = new TopicSubscription(this.broker, context, info, this.usageManager);
            PMQDestination destination = info.getDestination();
            if (destination != null && this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
                entry.configure((Broker)this.broker, this.usageManager, answer);
            }
            answer.init();
            return answer;
        }
        catch (Exception e) {
            LOG.error("Failed to create TopicSubscription ", e);
            JMSException jmsEx = new JMSException("Couldn't create TopicSubscription");
            jmsEx.setLinkedException(e);
            throw jmsEx;
        }
    }

    public String toString() {
        return "TempTopicRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.usageManager.getMemoryUsage().getPercentUsage() + "%";
    }

    @Override
    public void removeDestination(ConnectionContext context, PMQDestination destination, long timeout) throws Exception {
        if (timeout == 0L) {
            timeout = 1L;
        }
        super.removeDestination(context, destination, timeout);
    }
}

