/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.cursors;

import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.cursors.PendingNode;
import com.primeton.pmq.command.MessageId;
import com.primeton.pmq.management.SizeStatisticImpl;
import java.util.Map;

public class PendingMessageHelper {
    private final Map<MessageId, PendingNode> map;
    private final SizeStatisticImpl messageSize;

    public PendingMessageHelper(Map<MessageId, PendingNode> map, SizeStatisticImpl messageSize) {
        this.map = map;
        this.messageSize = messageSize;
    }

    public void addToMap(MessageReference message, PendingNode node) {
        PendingNode previous = this.map.put(message.getMessageId(), node);
        if (previous != null) {
            try {
                this.messageSize.addSize(-previous.getMessage().getSize());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.messageSize.addSize(message.getSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PendingNode removeFromMap(MessageReference message) {
        PendingNode removed = this.map.remove(message.getMessageId());
        if (removed != null) {
            try {
                this.messageSize.addSize(-removed.getMessage().getSize());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return removed;
    }
}

