/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.policy;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.SubscriptionRecovery;
import com.primeton.pmq.broker.region.Topic;
import com.primeton.pmq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.filter.DestinationFilter;
import java.util.ArrayList;

public class FixedCountSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private volatile MessageReference[] messages;
    private int maximumSize = 100;
    private int tail;

    @Override
    public SubscriptionRecoveryPolicy copy() {
        FixedCountSubscriptionRecoveryPolicy rc = new FixedCountSubscriptionRecoveryPolicy();
        rc.setMaximumSize(this.maximumSize);
        return rc;
    }

    @Override
    public synchronized boolean add(ConnectionContext context, MessageReference node) throws Exception {
        this.messages[this.tail++] = node;
        if (this.tail >= this.messages.length) {
            this.tail = 0;
        }
        return true;
    }

    @Override
    public synchronized void recover(ConnectionContext context, Topic topic, SubscriptionRecovery sub) throws Exception {
        int t = this.tail;
        if (this.messages[t] == null) {
            t = 0;
        }
        if (this.messages[t] == null) {
            return;
        }
        do {
            MessageReference node = this.messages[t];
            sub.addRecoveredMessage(context, node);
            if (++t < this.messages.length) continue;
            t = 0;
        } while (t != this.tail);
    }

    @Override
    public void start() throws Exception {
        this.messages = new MessageReference[this.maximumSize];
    }

    @Override
    public void stop() throws Exception {
        this.messages = null;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    @Override
    public synchronized Message[] browse(PMQDestination destination) throws Exception {
        ArrayList<Message> result = new ArrayList<Message>();
        DestinationFilter filter = DestinationFilter.parseFilter(destination);
        int t = this.tail;
        if (this.messages[t] == null) {
            t = 0;
        }
        if (this.messages[t] != null) {
            do {
                MessageReference ref;
                Message message;
                if (filter.matches((message = (ref = this.messages[t]).getMessage()).getDestination())) {
                    result.add(message);
                }
                if (++t < this.messages.length) continue;
                t = 0;
            } while (t != this.tail);
        }
        return result.toArray(new Message[result.size()]);
    }

    @Override
    public void setBroker(Broker broker) {
    }
}

