/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.policy;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.SubscriptionRecovery;
import com.primeton.pmq.broker.region.Topic;
import com.primeton.pmq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.memory.list.DestinationBasedMessageList;
import com.primeton.pmq.memory.list.MessageList;
import com.primeton.pmq.memory.list.SimpleMessageList;
import java.util.List;

public class FixedSizedSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private MessageList buffer;
    private int maximumSize = 65536;
    private boolean useSharedBuffer = true;

    @Override
    public SubscriptionRecoveryPolicy copy() {
        FixedSizedSubscriptionRecoveryPolicy rc = new FixedSizedSubscriptionRecoveryPolicy();
        rc.setMaximumSize(this.maximumSize);
        rc.setUseSharedBuffer(this.useSharedBuffer);
        return rc;
    }

    @Override
    public boolean add(ConnectionContext context, MessageReference message) throws Exception {
        this.buffer.add(message);
        return true;
    }

    @Override
    public void recover(ConnectionContext context, Topic topic, SubscriptionRecovery sub) throws Exception {
        List copy = this.buffer.getMessages(sub.getPMQDestination());
        if (!copy.isEmpty()) {
            for (MessageReference node : copy) {
                sub.addRecoveredMessage(context, node);
            }
        }
    }

    @Override
    public void start() throws Exception {
        this.buffer = this.createMessageList();
    }

    @Override
    public void stop() throws Exception {
        this.buffer.clear();
    }

    public MessageList getBuffer() {
        return this.buffer;
    }

    public void setBuffer(MessageList buffer) {
        this.buffer = buffer;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public boolean isUseSharedBuffer() {
        return this.useSharedBuffer;
    }

    public void setUseSharedBuffer(boolean useSharedBuffer) {
        this.useSharedBuffer = useSharedBuffer;
    }

    @Override
    public Message[] browse(PMQDestination destination) throws Exception {
        return this.buffer.browse(destination);
    }

    @Override
    public void setBroker(Broker broker) {
    }

    protected MessageList createMessageList() {
        if (this.useSharedBuffer) {
            return new SimpleMessageList(this.maximumSize);
        }
        return new DestinationBasedMessageList(this.maximumSize);
    }
}

