/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.policy;

import com.primeton.pmq.PMQMessageTransformation;
import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.SubscriptionRecovery;
import com.primeton.pmq.broker.region.Topic;
import com.primeton.pmq.broker.region.policy.MessageQuery;
import com.primeton.pmq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.primeton.pmq.command.ConnectionId;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.MessageId;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.ProducerId;
import com.primeton.pmq.command.SessionId;
import com.primeton.pmq.util.IdGenerator;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBasedSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(QueryBasedSubscriptionRecoveryPolicy.class);
    private MessageQuery query;
    private final AtomicLong messageSequence = new AtomicLong(0L);
    private final IdGenerator idGenerator = new IdGenerator();
    private final ProducerId producerId = this.createProducerId();

    @Override
    public SubscriptionRecoveryPolicy copy() {
        QueryBasedSubscriptionRecoveryPolicy rc = new QueryBasedSubscriptionRecoveryPolicy();
        rc.setQuery(this.query);
        return rc;
    }

    @Override
    public boolean add(ConnectionContext context, MessageReference message) throws Exception {
        return this.query.validateUpdate(message.getMessage());
    }

    @Override
    public void recover(final ConnectionContext context, final Topic topic, final SubscriptionRecovery sub) throws Exception {
        if (this.query != null) {
            PMQDestination destination = sub.getPMQDestination();
            this.query.execute(destination, new MessageListener(){

                @Override
                public void onMessage(javax.jms.Message message) {
                    QueryBasedSubscriptionRecoveryPolicy.this.dispatchInitialMessage(message, topic, context, sub);
                }
            });
        }
    }

    @Override
    public void start() throws Exception {
        if (this.query == null) {
            throw new IllegalArgumentException("No query property configured");
        }
    }

    @Override
    public void stop() throws Exception {
    }

    public MessageQuery getQuery() {
        return this.query;
    }

    public void setQuery(MessageQuery query) {
        this.query = query;
    }

    @Override
    public Message[] browse(PMQDestination dest) throws Exception {
        return new Message[0];
    }

    @Override
    public void setBroker(Broker broker) {
    }

    protected void dispatchInitialMessage(javax.jms.Message message, Destination regionDestination, ConnectionContext context, SubscriptionRecovery sub) {
        try {
            PMQMessage activeMessage = PMQMessageTransformation.transformMessage(message, null);
            PMQDestination destination = activeMessage.getDestination();
            if (destination == null) {
                destination = sub.getPMQDestination();
                activeMessage.setDestination(destination);
            }
            activeMessage.setRegionDestination(regionDestination);
            this.configure(activeMessage);
            sub.addRecoveredMessage(context, activeMessage);
        }
        catch (Throwable e) {
            LOG.warn("Failed to dispatch initial message: {} into subscription. Reason: ", (Object)message, (Object)e);
        }
    }

    protected void configure(PMQMessage msg) throws JMSException {
        long sequenceNumber = this.messageSequence.incrementAndGet();
        msg.setMessageId(new MessageId(this.producerId, sequenceNumber));
        msg.onSend();
        msg.setProducerId(this.producerId);
    }

    protected ProducerId createProducerId() {
        String id = this.idGenerator.generateId();
        ConnectionId connectionId = new ConnectionId(id);
        SessionId sessionId = new SessionId(connectionId, 1L);
        return new ProducerId(sessionId, 1L);
    }
}

