/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.virtual;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationFilter;
import com.primeton.pmq.broker.region.virtual.FilteredDestination;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.filter.MessageEvaluationContext;
import com.primeton.pmq.filter.NonCachedMessageEvaluationContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class CompositeDestinationFilter
extends DestinationFilter {
    private Collection forwardDestinations;
    private boolean forwardOnly;
    private boolean concurrentSend = false;

    public CompositeDestinationFilter(Destination next, Collection forwardDestinations, boolean forwardOnly, boolean concurrentSend) {
        super(next);
        this.forwardDestinations = forwardDestinations;
        this.forwardOnly = forwardOnly;
        this.concurrentSend = concurrentSend;
    }

    @Override
    public void send(final ProducerBrokerExchange context, final Message message) throws Exception {
        NonCachedMessageEvaluationContext messageContext = null;
        LinkedList<PMQDestination> matchingDestinations = new LinkedList<PMQDestination>();
        Iterator iter = this.forwardDestinations.iterator();
        while (iter.hasNext()) {
            PMQDestination destination = null;
            Object value = iter.next();
            if (value instanceof FilteredDestination) {
                FilteredDestination filteredDestination = (FilteredDestination)value;
                if (messageContext == null) {
                    messageContext = new NonCachedMessageEvaluationContext();
                    ((MessageEvaluationContext)messageContext).setMessageReference(message);
                }
                messageContext.setDestination(filteredDestination.getDestination());
                if (filteredDestination.matches(messageContext)) {
                    destination = filteredDestination.getDestination();
                }
            } else if (value instanceof PMQDestination) {
                destination = (PMQDestination)value;
            }
            if (destination == null) continue;
            matchingDestinations.add(destination);
        }
        final CountDownLatch concurrent = new CountDownLatch(this.concurrentSend ? matchingDestinations.size() : 0);
        final AtomicReference exceptionAtomicReference = new AtomicReference();
        final BrokerService brokerService = context.getConnectionContext().getBroker().getBrokerService();
        for (final PMQDestination destination : matchingDestinations) {
            if (concurrent.getCount() > 0L) {
                brokerService.getTaskRunnerFactory().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (exceptionAtomicReference.get() == null) {
                                CompositeDestinationFilter.this.doForward(context.copy(), message, brokerService.getRegionBroker(), destination);
                            }
                        }
                        catch (Exception e) {
                            exceptionAtomicReference.set(e);
                        }
                        finally {
                            concurrent.countDown();
                        }
                    }
                });
                continue;
            }
            this.doForward(context, message, brokerService.getRegionBroker(), destination);
        }
        if (!this.forwardOnly) {
            super.send(context, message);
        }
        concurrent.await();
        if (exceptionAtomicReference.get() != null) {
            throw (Exception)exceptionAtomicReference.get();
        }
    }

    private void doForward(ProducerBrokerExchange context, Message message, Broker regionBroker, PMQDestination destination) throws Exception {
        Message forwardedMessage = message.copy();
        forwardedMessage.setMemoryUsage(null);
        forwardedMessage.setOriginalDestination(message.getDestination());
        forwardedMessage.setDestination(destination);
        context.setMutable(true);
        regionBroker.send(context, forwardedMessage);
    }
}

