/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.virtual;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationFilter;
import com.primeton.pmq.broker.region.DestinationInterceptor;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirroredQueue
implements DestinationInterceptor,
BrokerServiceAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(MirroredQueue.class);
    private String prefix = "VirtualTopic.Mirror.";
    private String postfix = "";
    private boolean copyMessage = true;
    private BrokerService brokerService;

    @Override
    public Destination intercept(final Destination destination) {
        if (destination.getPMQDestination().isQueue() && (!destination.getPMQDestination().isTemporary() || this.brokerService.isUseTempMirroredQueues())) {
            try {
                final Destination mirrorDestination = this.getMirrorDestination(destination);
                if (mirrorDestination != null) {
                    return new DestinationFilter(destination){

                        @Override
                        public void send(ProducerBrokerExchange context, Message message) throws Exception {
                            message.setDestination(mirrorDestination.getPMQDestination());
                            mirrorDestination.send(context, message);
                            if (MirroredQueue.this.isCopyMessage()) {
                                message = message.copy();
                            }
                            message.setDestination(destination.getPMQDestination());
                            message.setMemoryUsage(null);
                            super.send(context, message);
                        }
                    };
                }
            }
            catch (Exception e) {
                LOG.error("Failed to lookup the mirror destination for: {}", (Object)destination, (Object)e);
            }
        }
        return destination;
    }

    @Override
    public void remove(Destination destination) {
        if (this.brokerService == null) {
            throw new IllegalArgumentException("No brokerService injected!");
        }
        PMQDestination topic = this.getMirrorTopic(destination.getPMQDestination());
        if (topic != null) {
            try {
                this.brokerService.removeDestination(topic);
            }
            catch (Exception e) {
                LOG.error("Failed to remove mirror destination for {}", (Object)destination, (Object)e);
            }
        }
    }

    @Override
    public void create(Broker broker, ConnectionContext context, PMQDestination destination) {
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isCopyMessage() {
        return this.copyMessage;
    }

    public void setCopyMessage(boolean copyMessage) {
        this.copyMessage = copyMessage;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected Destination getMirrorDestination(Destination destination) throws Exception {
        if (this.brokerService == null) {
            throw new IllegalArgumentException("No brokerService injected!");
        }
        PMQDestination topic = this.getMirrorTopic(destination.getPMQDestination());
        return this.brokerService.getDestination(topic);
    }

    protected PMQDestination getMirrorTopic(PMQDestination original) {
        return new PMQTopic(this.prefix + original.getPhysicalName() + this.postfix);
    }
}

