/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.virtual;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationFilter;
import com.primeton.pmq.broker.region.DestinationInterceptor;
import com.primeton.pmq.broker.region.virtual.VirtualDestination;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.filter.DestinationMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class VirtualDestinationInterceptor
implements DestinationInterceptor {
    private DestinationMap destinationMap = new DestinationMap();
    private DestinationMap mappedDestinationMap = new DestinationMap();
    private VirtualDestination[] virtualDestinations;

    @Override
    public Destination intercept(Destination destination) {
        PMQDestination pmqDestination = destination.getPMQDestination();
        Set matchingDestinations = this.destinationMap.get(pmqDestination);
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        for (VirtualDestination virtualDestination : matchingDestinations) {
            Destination newDestination = virtualDestination.intercept(destination);
            destinations.add(newDestination);
        }
        if (!destinations.isEmpty()) {
            if (destinations.size() == 1) {
                return (Destination)destinations.get(0);
            }
            return this.createCompositeDestination(destination, destinations);
        }
        Set mappedDestinations = this.mappedDestinationMap.get(pmqDestination);
        if (!mappedDestinations.isEmpty()) {
            VirtualDestination virtualDestination;
            virtualDestination = mappedDestinations.toArray(new VirtualDestination[mappedDestinations.size()])[0];
            return virtualDestination.interceptMappedDestination(destination);
        }
        return destination;
    }

    @Override
    public synchronized void create(Broker broker, ConnectionContext context, PMQDestination destination) throws Exception {
        for (VirtualDestination virt : this.virtualDestinations) {
            virt.create(broker, context, destination);
        }
    }

    @Override
    public synchronized void remove(Destination destination) {
    }

    public VirtualDestination[] getVirtualDestinations() {
        return this.virtualDestinations;
    }

    public void setVirtualDestinations(VirtualDestination[] virtualDestinations) {
        this.destinationMap = new DestinationMap();
        this.mappedDestinationMap = new DestinationMap();
        this.virtualDestinations = virtualDestinations;
        for (int i = 0; i < virtualDestinations.length; ++i) {
            VirtualDestination virtualDestination = virtualDestinations[i];
            this.destinationMap.put(virtualDestination.getVirtualDestination(), virtualDestination);
            this.mappedDestinationMap.put(virtualDestination.getMappedDestinations(), virtualDestination);
        }
    }

    protected Destination createCompositeDestination(Destination destination, final List<Destination> destinations) {
        return new DestinationFilter(destination){

            @Override
            public void send(ProducerBrokerExchange context, Message messageSend) throws Exception {
                for (Destination destination : destinations) {
                    destination.send(context, messageSend);
                }
            }
        };
    }

    public String toString() {
        return "VirtualDestinationInterceptor" + Arrays.asList(this.virtualDestinations);
    }
}

