/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.util;

import com.primeton.pmq.broker.BrokerPluginSupport;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.policy.DeadLetterStrategy;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampingBrokerPlugin
extends BrokerPluginSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TimeStampingBrokerPlugin.class);
    long zeroExpirationOverride = 0L;
    long ttlCeiling = 0L;
    boolean futureOnly = false;
    boolean processNetworkMessages = false;

    public void setZeroExpirationOverride(long ttl) {
        this.zeroExpirationOverride = ttl;
    }

    public void setTtlCeiling(long ttlCeiling) {
        this.ttlCeiling = ttlCeiling;
    }

    public void setFutureOnly(boolean futureOnly) {
        this.futureOnly = futureOnly;
    }

    public void setProcessNetworkMessages(Boolean processNetworkMessages) {
        this.processNetworkMessages = processNetworkMessages;
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        if (message.getTimestamp() > 0L && !this.isDestinationDLQ(message) && (this.processNetworkMessages || message.getBrokerPath() == null || message.getBrokerPath().length == 0)) {
            long oldExpiration = message.getExpiration();
            long newTimeStamp = System.currentTimeMillis();
            long timeToLive = this.zeroExpirationOverride;
            long oldTimestamp = message.getTimestamp();
            if (oldExpiration > 0L) {
                timeToLive = oldExpiration - oldTimestamp;
            }
            if (timeToLive > 0L && this.ttlCeiling > 0L && timeToLive > this.ttlCeiling) {
                timeToLive = this.ttlCeiling;
            }
            long expiration = timeToLive + newTimeStamp;
            if (!this.futureOnly || expiration > oldExpiration) {
                if (timeToLive > 0L && expiration > 0L) {
                    message.setExpiration(expiration);
                }
                message.setTimestamp(newTimeStamp);
                LOG.debug("Set message {} timestamp from {} to {}", message.getMessageId(), oldTimestamp, newTimeStamp);
            }
        }
        super.send(producerExchange, message);
    }

    private boolean isDestinationDLQ(Message message) {
        DeadLetterStrategy deadLetterStrategy;
        Destination regionDestination = (Destination)message.getRegionDestination();
        if (message != null && regionDestination != null && (deadLetterStrategy = regionDestination.getDeadLetterStrategy()) != null && message.getOriginalDestination() != null) {
            PMQMessage tmp = new PMQMessage();
            tmp.setDestination(message.getOriginalDestination());
            tmp.setRegionDestination(regionDestination);
            PMQDestination deadLetterDestination = deadLetterStrategy.getDeadLetterQueueFor(tmp, null);
            if (deadLetterDestination.equals(message.getDestination())) {
                return true;
            }
        }
        return false;
    }
}

