/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.camel.component;

import com.primeton.pmq.EnhancedConnection;
import com.primeton.pmq.Service;
import com.primeton.pmq.advisory.DestinationSource;
import com.primeton.pmq.camel.component.CamelEndpointLoader;
import com.primeton.pmq.camel.component.OriginalDestinationPropagateStrategy;
import com.primeton.pmq.camel.component.PMQConfiguration;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Connection;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.SingleConnectionFactory;

public class PMQComponent
extends JmsComponent {
    private final CopyOnWriteArrayList<SingleConnectionFactory> singleConnectionFactoryList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Service> pooledConnectionFactoryServiceList = new CopyOnWriteArrayList();
    private static final transient Logger LOG = LoggerFactory.getLogger(PMQComponent.class);
    private boolean exposeAllQueues;
    private CamelEndpointLoader endpointLoader;
    private EnhancedConnection connection;
    DestinationSource source;

    public static PMQComponent pmqComponent() {
        return new PMQComponent();
    }

    public static PMQComponent pmqComponent(String brokerURL) {
        PMQComponent answer = new PMQComponent();
        if (answer.getConfiguration() instanceof PMQConfiguration) {
            ((PMQConfiguration)answer.getConfiguration()).setBrokerURL(brokerURL);
        }
        return answer;
    }

    public PMQComponent() {
    }

    public PMQComponent(CamelContext context) {
        super(context);
    }

    public PMQComponent(PMQConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public void setBrokerURL(String brokerURL) {
        if (this.getConfiguration() instanceof PMQConfiguration) {
            ((PMQConfiguration)this.getConfiguration()).setBrokerURL(brokerURL);
        }
    }

    public void setTrustAllPackages(boolean trustAllPackages) {
        if (this.getConfiguration() instanceof PMQConfiguration) {
            ((PMQConfiguration)this.getConfiguration()).setTrustAllPackages(trustAllPackages);
        }
    }

    public boolean isExposeAllQueues() {
        return this.exposeAllQueues;
    }

    public void setExposeAllQueues(boolean exposeAllQueues) {
        this.exposeAllQueues = exposeAllQueues;
    }

    public void setUsePooledConnection(boolean usePooledConnection) {
        if (this.getConfiguration() instanceof PMQConfiguration) {
            ((PMQConfiguration)this.getConfiguration()).setUsePooledConnection(usePooledConnection);
        }
    }

    public void setUseSingleConnection(boolean useSingleConnection) {
        if (this.getConfiguration() instanceof PMQConfiguration) {
            ((PMQConfiguration)this.getConfiguration()).setUseSingleConnection(useSingleConnection);
        }
    }

    protected void addPooledConnectionFactoryService(Service pooledConnectionFactoryService) {
        this.pooledConnectionFactoryServiceList.add(pooledConnectionFactoryService);
    }

    protected void addSingleConnectionFactory(SingleConnectionFactory singleConnectionFactory) {
        this.singleConnectionFactoryList.add(singleConnectionFactory);
    }

    @Override
    protected String convertPathToActualDestination(String path, Map<String, Object> parameters) {
        String query;
        Map<String, Object> options = IntrospectionSupport.extractProperties(parameters, "destination.");
        try {
            query = URISupport.createQueryString(options);
        }
        catch (URISyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        if (ObjectHelper.isNotEmpty(query)) {
            return path + "?" + query;
        }
        return path;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.isExposeAllQueues()) {
            this.createDestinationSource();
            this.endpointLoader = new CamelEndpointLoader(this.getCamelContext(), this.source);
            this.endpointLoader.afterPropertiesSet();
        }
        if (this.getMessageCreatedStrategy() == null) {
            this.setMessageCreatedStrategy(new OriginalDestinationPropagateStrategy());
        }
    }

    protected void createDestinationSource() {
        try {
            if (this.source == null) {
                if (this.connection == null) {
                    Connection value = this.getConfiguration().getConnectionFactory().createConnection();
                    if (!(value instanceof EnhancedConnection)) {
                        throw new IllegalArgumentException("Created JMS Connection is not an EnhancedConnection: " + value);
                    }
                    this.connection = (EnhancedConnection)value;
                    this.connection.start();
                }
                this.source = this.connection.getDestinationSource();
            }
        }
        catch (Throwable t) {
            LOG.info("Can't get destination source, endpoint completer will not work", t);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.source != null) {
            this.source.stop();
            this.source = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        for (Service service : this.pooledConnectionFactoryServiceList) {
            service.stop();
        }
        this.pooledConnectionFactoryServiceList.clear();
        for (SingleConnectionFactory singleConnectionFactory : this.singleConnectionFactoryList) {
            singleConnectionFactory.destroy();
        }
        this.singleConnectionFactoryList.clear();
        super.doStop();
    }

    @Override
    public void setConfiguration(JmsConfiguration configuration) {
        if (configuration instanceof PMQConfiguration) {
            ((PMQConfiguration)configuration).setPMQComponent(this);
        }
        super.setConfiguration(configuration);
    }

    @Override
    protected JmsConfiguration createConfiguration() {
        PMQConfiguration answer = new PMQConfiguration();
        answer.setPMQComponent(this);
        return answer;
    }
}

