/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.camel.component.broker;

import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.inteceptor.MessageInterceptor;
import com.primeton.pmq.camel.component.broker.BrokerEndpoint;
import com.primeton.pmq.camel.component.broker.BrokerJmsMessage;
import com.primeton.pmq.command.Message;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.impl.DefaultConsumer;

public class BrokerConsumer
extends DefaultConsumer
implements MessageInterceptor {
    private final JmsBinding jmsBinding = new JmsBinding();

    public BrokerConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ((BrokerEndpoint)this.getEndpoint()).addMessageInterceptor(this);
    }

    @Override
    protected void doStop() throws Exception {
        ((BrokerEndpoint)this.getEndpoint()).removeMessageInterceptor(this);
        super.doStop();
    }

    @Override
    public void intercept(ProducerBrokerExchange producerExchange, Message message) {
        Exchange exchange = this.getEndpoint().createExchange(ExchangePattern.InOnly);
        exchange.setIn(new BrokerJmsMessage((javax.jms.Message)((Object)message), this.jmsBinding));
        exchange.setProperty("CamelBinding", this.jmsBinding);
        exchange.setProperty("producerBrokerExchange", producerExchange);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing intercepted message: " + message, exchange, exchange.getException());
        }
    }
}

