/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.camel.converter;

import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQObjectMessage;
import com.primeton.pmq.command.PMQTextMessage;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.JmsBinding;

@Converter
public class PMQMessageConverter {
    private JmsBinding binding = new JmsBinding();

    @Converter
    public PMQMessage toMessage(Exchange exchange) throws JMSException {
        PMQMessage message = PMQMessageConverter.createPMQMessage(exchange);
        this.getBinding().appendJmsProperties(message, exchange);
        return message;
    }

    @Converter
    public Processor toProcessor(final MessageListener listener) {
        return new Processor(){

            @Override
            public void process(Exchange exchange) throws Exception {
                PMQMessage message = PMQMessageConverter.this.toMessage(exchange);
                listener.onMessage(message);
            }

            public String toString() {
                return "Processor of MessageListener: " + listener;
            }
        };
    }

    private static PMQMessage createPMQMessage(Exchange exchange) throws JMSException {
        Object body = exchange.getIn().getBody();
        if (body instanceof String) {
            PMQTextMessage answer = new PMQTextMessage();
            answer.setText((String)body);
            return answer;
        }
        if (body instanceof Serializable) {
            PMQObjectMessage answer = new PMQObjectMessage();
            answer.setObject((Serializable)body);
            return answer;
        }
        return new PMQMessage();
    }

    public JmsBinding getBinding() {
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }
}

