/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.command;

import com.primeton.pmq.command.BaseCommand;
import com.primeton.pmq.command.BrokerId;
import com.primeton.pmq.command.ConnectionId;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.Response;
import com.primeton.pmq.state.CommandVisitor;
import java.io.IOException;

public class DestinationInfo
extends BaseCommand {
    public static final byte DATA_STRUCTURE_TYPE = 8;
    public static final byte ADD_OPERATION_TYPE = 0;
    public static final byte REMOVE_OPERATION_TYPE = 1;
    protected ConnectionId connectionId;
    protected PMQDestination destination;
    protected byte operationType;
    protected long timeout;
    protected BrokerId[] brokerPath;

    public DestinationInfo() {
    }

    public DestinationInfo(ConnectionId connectionId, byte operationType, PMQDestination destination) {
        this.connectionId = connectionId;
        this.operationType = operationType;
        this.destination = destination;
    }

    @Override
    public byte getDataStructureType() {
        return 8;
    }

    public boolean isAddOperation() {
        return this.operationType == 0;
    }

    public boolean isRemoveOperation() {
        return this.operationType == 1;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(ConnectionId connectionId) {
        this.connectionId = connectionId;
    }

    public PMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(PMQDestination destination) {
        this.destination = destination;
    }

    public byte getOperationType() {
        return this.operationType;
    }

    public void setOperationType(byte operationType) {
        this.operationType = operationType;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public BrokerId[] getBrokerPath() {
        return this.brokerPath;
    }

    public void setBrokerPath(BrokerId[] brokerPath) {
        this.brokerPath = brokerPath;
    }

    @Override
    public Response visit(CommandVisitor visitor) throws Exception {
        if (this.isAddOperation()) {
            return visitor.processAddDestination(this);
        }
        if (this.isRemoveOperation()) {
            return visitor.processRemoveDestination(this);
        }
        throw new IOException("Unknown operation type: " + this.getOperationType());
    }

    public DestinationInfo copy() {
        DestinationInfo result = new DestinationInfo();
        super.copy(result);
        result.connectionId = this.connectionId;
        result.destination = this.destination;
        result.operationType = this.operationType;
        result.brokerPath = this.brokerPath;
        return result;
    }
}

