/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.console.command;

import com.primeton.pmq.PMQConnectionMetaData;
import com.primeton.pmq.console.CommandContext;
import com.primeton.pmq.console.command.Command;
import com.primeton.pmq.util.IntrospectionSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.util.List;

public abstract class AbstractCommand
implements Command {
    public static final String COMMAND_OPTION_DELIMETER = ",";
    private boolean isPrintHelp;
    private boolean isPrintVersion;
    protected CommandContext context;

    @Override
    public void setCommandContext(CommandContext context) {
        this.context = context;
    }

    @Override
    public void execute(List<String> tokens) throws Exception {
        this.parseOptions(tokens);
        if (this.isPrintHelp) {
            this.printHelp();
        } else if (this.isPrintVersion) {
            this.context.printVersion(PMQConnectionMetaData.PROVIDER_VERSION);
        } else {
            this.runTask(tokens);
        }
    }

    protected void parseOptions(List<String> tokens) throws Exception {
        while (!tokens.isEmpty()) {
            String token = tokens.remove(0);
            if (token.startsWith("-")) {
                this.handleOption(token, tokens);
                continue;
            }
            tokens.add(0, token);
            return;
        }
    }

    protected void handleOption(String token, List<String> tokens) throws Exception {
        this.isPrintHelp = false;
        this.isPrintVersion = false;
        if (token.equals("-h") || token.equals("-?") || token.equals("--help")) {
            this.isPrintHelp = true;
            tokens.clear();
        } else if (token.equals("--version")) {
            this.isPrintVersion = true;
            tokens.clear();
        } else if (token.startsWith("-D")) {
            String key = token.substring(2);
            String value = "";
            int pos = key.indexOf("=");
            if (pos >= 0) {
                value = key.substring(pos + 1);
                key = key.substring(0, pos);
            }
            System.setProperty(key, value);
        } else {
            if (token.startsWith("--")) {
                String prop = token.substring(2);
                if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                    this.context.print("Property '" + prop + "' is not specified!");
                } else if (IntrospectionSupport.setProperty(this, prop, tokens.remove(0))) {
                    return;
                }
            }
            this.context.printInfo("Unrecognized option: " + token);
            this.isPrintHelp = true;
        }
    }

    protected abstract void runTask(List<String> var1) throws Exception;

    protected abstract void printHelp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printHelpFromFile() {
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = this.getClass().getResourceAsStream(this.getName() + ".txt");
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                this.context.print(line);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void handleException(Exception exception, String serviceUrl) throws Exception {
        Throwable next;
        Throwable cause = exception.getCause();
        while ((next = cause.getCause()) != null) {
            cause = next;
        }
        if (!(cause instanceof ConnectException)) {
            this.context.printInfo("Failed to execute " + this.getName() + " task.");
            throw exception;
        }
        this.context.printInfo("Broker not available at: " + serviceUrl);
    }
}

