/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.console.filter;

import com.primeton.pmq.PMQConnectionFactory;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.console.filter.AbstractQueryFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueBrowser;
import javax.jms.Session;

public class AmqMessagesQueryFilter
extends AbstractQueryFilter {
    private URI brokerUrl;
    private Destination destination;
    private ConnectionFactory connectionFactory;

    public AmqMessagesQueryFilter(URI brokerUrl, Destination destination) {
        super(null);
        this.brokerUrl = brokerUrl;
        this.destination = destination;
    }

    public AmqMessagesQueryFilter(ConnectionFactory connectionFactory, Destination destination) {
        super(null);
        this.destination = destination;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public List query(List queries) throws Exception {
        String selector = "";
        for (Object query : queries) {
            selector = selector + "(" + query.toString() + ") AND ";
        }
        if (!selector.equals("")) {
            selector = selector.substring(0, selector.length() - 5);
        }
        if (this.destination instanceof PMQQueue) {
            return this.queryMessages((PMQQueue)this.destination, selector);
        }
        return this.queryMessages((PMQTopic)this.destination, selector);
    }

    protected List queryMessages(PMQQueue queue2, String selector) throws Exception {
        Connection conn = this.createConnection();
        Session sess = conn.createSession(false, 1);
        QueueBrowser browser = sess.createBrowser(queue2, selector);
        ArrayList messages = Collections.list(browser.getEnumeration());
        conn.close();
        return messages;
    }

    protected List queryMessages(PMQTopic topic, String selector) throws Exception {
        return null;
    }

    protected Connection createConnection() throws JMSException {
        if (null == this.connectionFactory) {
            this.connectionFactory = new PMQConnectionFactory(this.getBrokerUrl());
        }
        Connection conn = this.connectionFactory.createConnection();
        conn.start();
        return conn;
    }

    public URI getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(URI brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }
}

