/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.leveldb;

import com.primeton.pmq.broker.jmx.MBeanInfo;

public interface LevelDBStoreViewMBean {
    @MBeanInfo(value="The directory holding the store index data.")
    public String getIndexDirectory();

    @MBeanInfo(value="The directory holding the store log data.")
    public String getLogDirectory();

    @MBeanInfo(value="The size the log files are allowed to grow to.")
    public long getLogSize();

    @MBeanInfo(value="The implementation of the LevelDB index being used.")
    public String getIndexFactory();

    @MBeanInfo(value="Are writes synced to disk.")
    public boolean getSync();

    @MBeanInfo(value="Is data verified against checksums as it's loaded back from disk.")
    public boolean getVerifyChecksums();

    @MBeanInfo(value="The maximum number of open files the index will open at one time.")
    public int getIndexMaxOpenFiles();

    @MBeanInfo(value="Number of keys between restart points for delta encoding of keys in the index")
    public int getIndexBlockRestartInterval();

    @MBeanInfo(value="Do aggressive checking of store data")
    public boolean getParanoidChecks();

    @MBeanInfo(value="Amount of data to build up in memory for the index before converting to a sorted on-disk file.")
    public int getIndexWriteBufferSize();

    @MBeanInfo(value="Approximate size of user data packed per block for the index")
    public int getIndexBlockSize();

    @MBeanInfo(value="The type of compression to use for the index")
    public String getIndexCompression();

    @MBeanInfo(value="The size of the cache index")
    public long getIndexCacheSize();

    @MBeanInfo(value="The maximum amount of async writes to buffer up")
    public int getAsyncBufferSize();

    @MBeanInfo(value="The number of units of work which have been closed.")
    public long getUowClosedCounter();

    @MBeanInfo(value="The number of units of work which have been canceled.")
    public long getUowCanceledCounter();

    @MBeanInfo(value="The number of units of work which started getting stored.")
    public long getUowStoringCounter();

    @MBeanInfo(value="The number of units of work which completed getting stored")
    public long getUowStoredCounter();

    @MBeanInfo(value="Gets and resets the maximum time (in ms) a unit of work took to complete.")
    public double resetUowMaxCompleteLatency();

    @MBeanInfo(value="Gets and resets the maximum time (in ms) an index write batch took to execute.")
    public double resetMaxIndexWriteLatency();

    @MBeanInfo(value="Gets and resets the maximum time (in ms) a log write took to execute (includes the index write latency).")
    public double resetMaxLogWriteLatency();

    @MBeanInfo(value="Gets and resets the maximum time (in ms) a log flush took to execute.")
    public double resetMaxLogFlushLatency();

    @MBeanInfo(value="Gets and resets the maximum time (in ms) a log rotation took to perform.")
    public double resetMaxLogRotateLatency();

    @MBeanInfo(value="Gets the maximum time (in ms) a unit of work took to complete.")
    public double getUowMaxCompleteLatency();

    @MBeanInfo(value="Gets the maximum time (in ms) an index write batch took to execute.")
    public double getMaxIndexWriteLatency();

    @MBeanInfo(value="Gets the maximum time (in ms) a log write took to execute (includes the index write latency).")
    public double getMaxLogWriteLatency();

    @MBeanInfo(value="Gets the maximum time (in ms) a log flush took to execute.")
    public double getMaxLogFlushLatency();

    @MBeanInfo(value="Gets the maximum time (in ms) a log rotation took to perform.")
    public double getMaxLogRotateLatency();

    @MBeanInfo(value="Gets the index statistics.")
    public String getIndexStats();

    @MBeanInfo(value="Compacts disk usage")
    public void compact();
}

