/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.memory.buffer;

import com.primeton.pmq.memory.buffer.MessageBuffer;
import com.primeton.pmq.memory.buffer.MessageQueue;
import java.util.ArrayList;
import java.util.List;

public class SizeBasedMessageBuffer
implements MessageBuffer {
    private int limit = 0x640000;
    private List<MessageQueue> bubbleList = new ArrayList<MessageQueue>();
    private int size;
    private Object lock = new Object();

    public SizeBasedMessageBuffer() {
    }

    public SizeBasedMessageBuffer(int limit) {
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageQueue createMessageQueue() {
        MessageQueue queue2 = new MessageQueue(this);
        Object object = this.lock;
        synchronized (object) {
            queue2.setPosition(this.bubbleList.size());
            this.bubbleList.add(queue2);
        }
        return queue2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSizeChanged(MessageQueue queue2, int delta, int queueSize) {
        Object object = this.lock;
        synchronized (object) {
            this.bubbleUp(queue2, queueSize);
            this.size += delta;
            while (this.size > this.limit) {
                MessageQueue biggest = this.bubbleList.get(0);
                this.size -= biggest.evictMessage();
                this.bubbleDown(biggest, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            for (MessageQueue queue2 : this.bubbleList) {
                queue2.clear();
            }
            this.size = 0;
        }
    }

    protected void bubbleUp(MessageQueue queue2, int queueSize) {
        MessageQueue pivot;
        int position = queue2.getPosition();
        while (--position >= 0 && (pivot = this.bubbleList.get(position)).getSize() < queueSize) {
            this.swap(position, pivot, position + 1, queue2);
        }
    }

    protected void bubbleDown(MessageQueue biggest, int position) {
        MessageQueue pivot;
        int queueSize = biggest.getSize();
        int end = this.bubbleList.size();
        int second = position + 1;
        while (second < end && (pivot = this.bubbleList.get(second)).getSize() > queueSize) {
            this.swap(position, biggest, second, pivot);
            position = second++;
        }
    }

    protected void swap(int firstPosition, MessageQueue first, int secondPosition, MessageQueue second) {
        this.bubbleList.set(firstPosition, second);
        this.bubbleList.set(secondPosition, first);
        first.setPosition(secondPosition);
        second.setPosition(firstPosition);
    }
}

