/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v1;

import com.primeton.pmq.openwire.DataStreamMarshaller;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v1.BrokerIdMarshaller;
import com.primeton.pmq.openwire.v1.BrokerInfoMarshaller;
import com.primeton.pmq.openwire.v1.ConnectionControlMarshaller;
import com.primeton.pmq.openwire.v1.ConnectionErrorMarshaller;
import com.primeton.pmq.openwire.v1.ConnectionIdMarshaller;
import com.primeton.pmq.openwire.v1.ConnectionInfoMarshaller;
import com.primeton.pmq.openwire.v1.ConsumerControlMarshaller;
import com.primeton.pmq.openwire.v1.ConsumerIdMarshaller;
import com.primeton.pmq.openwire.v1.ConsumerInfoMarshaller;
import com.primeton.pmq.openwire.v1.ControlCommandMarshaller;
import com.primeton.pmq.openwire.v1.DataArrayResponseMarshaller;
import com.primeton.pmq.openwire.v1.DataResponseMarshaller;
import com.primeton.pmq.openwire.v1.DestinationInfoMarshaller;
import com.primeton.pmq.openwire.v1.DiscoveryEventMarshaller;
import com.primeton.pmq.openwire.v1.ExceptionResponseMarshaller;
import com.primeton.pmq.openwire.v1.FlushCommandMarshaller;
import com.primeton.pmq.openwire.v1.IntegerResponseMarshaller;
import com.primeton.pmq.openwire.v1.JournalQueueAckMarshaller;
import com.primeton.pmq.openwire.v1.JournalTopicAckMarshaller;
import com.primeton.pmq.openwire.v1.JournalTraceMarshaller;
import com.primeton.pmq.openwire.v1.JournalTransactionMarshaller;
import com.primeton.pmq.openwire.v1.KeepAliveInfoMarshaller;
import com.primeton.pmq.openwire.v1.LastPartialCommandMarshaller;
import com.primeton.pmq.openwire.v1.LocalTransactionIdMarshaller;
import com.primeton.pmq.openwire.v1.MessageAckMarshaller;
import com.primeton.pmq.openwire.v1.MessageDispatchMarshaller;
import com.primeton.pmq.openwire.v1.MessageDispatchNotificationMarshaller;
import com.primeton.pmq.openwire.v1.MessageIdMarshaller;
import com.primeton.pmq.openwire.v1.NetworkBridgeFilterMarshaller;
import com.primeton.pmq.openwire.v1.PMQBytesMessageMarshaller;
import com.primeton.pmq.openwire.v1.PMQMapMessageMarshaller;
import com.primeton.pmq.openwire.v1.PMQMessageMarshaller;
import com.primeton.pmq.openwire.v1.PMQObjectMessageMarshaller;
import com.primeton.pmq.openwire.v1.PMQQueueMarshaller;
import com.primeton.pmq.openwire.v1.PMQStreamMessageMarshaller;
import com.primeton.pmq.openwire.v1.PMQTempQueueMarshaller;
import com.primeton.pmq.openwire.v1.PMQTempTopicMarshaller;
import com.primeton.pmq.openwire.v1.PMQTextMessageMarshaller;
import com.primeton.pmq.openwire.v1.PMQTopicMarshaller;
import com.primeton.pmq.openwire.v1.PartialCommandMarshaller;
import com.primeton.pmq.openwire.v1.ProducerIdMarshaller;
import com.primeton.pmq.openwire.v1.ProducerInfoMarshaller;
import com.primeton.pmq.openwire.v1.RemoveInfoMarshaller;
import com.primeton.pmq.openwire.v1.RemoveSubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v1.ReplayCommandMarshaller;
import com.primeton.pmq.openwire.v1.ResponseMarshaller;
import com.primeton.pmq.openwire.v1.SessionIdMarshaller;
import com.primeton.pmq.openwire.v1.SessionInfoMarshaller;
import com.primeton.pmq.openwire.v1.ShutdownInfoMarshaller;
import com.primeton.pmq.openwire.v1.SubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v1.TransactionInfoMarshaller;
import com.primeton.pmq.openwire.v1.WireFormatInfoMarshaller;
import com.primeton.pmq.openwire.v1.XATransactionIdMarshaller;

public final class MarshallerFactory {
    private static final DataStreamMarshaller[] MARSHALLER = new DataStreamMarshaller[256];

    private MarshallerFactory() {
    }

    private static void add(DataStreamMarshaller dsm) {
        MarshallerFactory.MARSHALLER[dsm.getDataStructureType()] = dsm;
    }

    public static DataStreamMarshaller[] createMarshallerMap(OpenWireFormat wireFormat) {
        return MARSHALLER;
    }

    static {
        MarshallerFactory.add(new LocalTransactionIdMarshaller());
        MarshallerFactory.add(new PartialCommandMarshaller());
        MarshallerFactory.add(new IntegerResponseMarshaller());
        MarshallerFactory.add(new PMQQueueMarshaller());
        MarshallerFactory.add(new PMQObjectMessageMarshaller());
        MarshallerFactory.add(new ConnectionIdMarshaller());
        MarshallerFactory.add(new ConnectionInfoMarshaller());
        MarshallerFactory.add(new ProducerInfoMarshaller());
        MarshallerFactory.add(new MessageDispatchNotificationMarshaller());
        MarshallerFactory.add(new SessionInfoMarshaller());
        MarshallerFactory.add(new TransactionInfoMarshaller());
        MarshallerFactory.add(new PMQStreamMessageMarshaller());
        MarshallerFactory.add(new MessageAckMarshaller());
        MarshallerFactory.add(new ProducerIdMarshaller());
        MarshallerFactory.add(new MessageIdMarshaller());
        MarshallerFactory.add(new PMQTempQueueMarshaller());
        MarshallerFactory.add(new RemoveSubscriptionInfoMarshaller());
        MarshallerFactory.add(new SessionIdMarshaller());
        MarshallerFactory.add(new DataArrayResponseMarshaller());
        MarshallerFactory.add(new JournalQueueAckMarshaller());
        MarshallerFactory.add(new ResponseMarshaller());
        MarshallerFactory.add(new ConnectionErrorMarshaller());
        MarshallerFactory.add(new ConsumerInfoMarshaller());
        MarshallerFactory.add(new XATransactionIdMarshaller());
        MarshallerFactory.add(new JournalTraceMarshaller());
        MarshallerFactory.add(new ConsumerIdMarshaller());
        MarshallerFactory.add(new PMQTextMessageMarshaller());
        MarshallerFactory.add(new SubscriptionInfoMarshaller());
        MarshallerFactory.add(new JournalTransactionMarshaller());
        MarshallerFactory.add(new ControlCommandMarshaller());
        MarshallerFactory.add(new LastPartialCommandMarshaller());
        MarshallerFactory.add(new NetworkBridgeFilterMarshaller());
        MarshallerFactory.add(new PMQBytesMessageMarshaller());
        MarshallerFactory.add(new WireFormatInfoMarshaller());
        MarshallerFactory.add(new PMQTempTopicMarshaller());
        MarshallerFactory.add(new DiscoveryEventMarshaller());
        MarshallerFactory.add(new ReplayCommandMarshaller());
        MarshallerFactory.add(new PMQTopicMarshaller());
        MarshallerFactory.add(new BrokerInfoMarshaller());
        MarshallerFactory.add(new DestinationInfoMarshaller());
        MarshallerFactory.add(new ShutdownInfoMarshaller());
        MarshallerFactory.add(new DataResponseMarshaller());
        MarshallerFactory.add(new ConnectionControlMarshaller());
        MarshallerFactory.add(new KeepAliveInfoMarshaller());
        MarshallerFactory.add(new FlushCommandMarshaller());
        MarshallerFactory.add(new ConsumerControlMarshaller());
        MarshallerFactory.add(new JournalTopicAckMarshaller());
        MarshallerFactory.add(new BrokerIdMarshaller());
        MarshallerFactory.add(new MessageDispatchMarshaller());
        MarshallerFactory.add(new PMQMapMessageMarshaller());
        MarshallerFactory.add(new PMQMessageMarshaller());
        MarshallerFactory.add(new RemoveInfoMarshaller());
        MarshallerFactory.add(new ExceptionResponseMarshaller());
    }
}

