/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v3;

import com.primeton.pmq.openwire.DataStreamMarshaller;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v3.BrokerIdMarshaller;
import com.primeton.pmq.openwire.v3.BrokerInfoMarshaller;
import com.primeton.pmq.openwire.v3.ConnectionControlMarshaller;
import com.primeton.pmq.openwire.v3.ConnectionErrorMarshaller;
import com.primeton.pmq.openwire.v3.ConnectionIdMarshaller;
import com.primeton.pmq.openwire.v3.ConnectionInfoMarshaller;
import com.primeton.pmq.openwire.v3.ConsumerControlMarshaller;
import com.primeton.pmq.openwire.v3.ConsumerIdMarshaller;
import com.primeton.pmq.openwire.v3.ConsumerInfoMarshaller;
import com.primeton.pmq.openwire.v3.ControlCommandMarshaller;
import com.primeton.pmq.openwire.v3.DataArrayResponseMarshaller;
import com.primeton.pmq.openwire.v3.DataResponseMarshaller;
import com.primeton.pmq.openwire.v3.DestinationInfoMarshaller;
import com.primeton.pmq.openwire.v3.DiscoveryEventMarshaller;
import com.primeton.pmq.openwire.v3.ExceptionResponseMarshaller;
import com.primeton.pmq.openwire.v3.FlushCommandMarshaller;
import com.primeton.pmq.openwire.v3.IntegerResponseMarshaller;
import com.primeton.pmq.openwire.v3.JournalQueueAckMarshaller;
import com.primeton.pmq.openwire.v3.JournalTopicAckMarshaller;
import com.primeton.pmq.openwire.v3.JournalTraceMarshaller;
import com.primeton.pmq.openwire.v3.JournalTransactionMarshaller;
import com.primeton.pmq.openwire.v3.KeepAliveInfoMarshaller;
import com.primeton.pmq.openwire.v3.LastPartialCommandMarshaller;
import com.primeton.pmq.openwire.v3.LocalTransactionIdMarshaller;
import com.primeton.pmq.openwire.v3.MessageAckMarshaller;
import com.primeton.pmq.openwire.v3.MessageDispatchMarshaller;
import com.primeton.pmq.openwire.v3.MessageDispatchNotificationMarshaller;
import com.primeton.pmq.openwire.v3.MessageIdMarshaller;
import com.primeton.pmq.openwire.v3.MessagePullMarshaller;
import com.primeton.pmq.openwire.v3.NetworkBridgeFilterMarshaller;
import com.primeton.pmq.openwire.v3.PMQBlobMessageMarshaller;
import com.primeton.pmq.openwire.v3.PMQBytesMessageMarshaller;
import com.primeton.pmq.openwire.v3.PMQMapMessageMarshaller;
import com.primeton.pmq.openwire.v3.PMQMessageMarshaller;
import com.primeton.pmq.openwire.v3.PMQObjectMessageMarshaller;
import com.primeton.pmq.openwire.v3.PMQQueueMarshaller;
import com.primeton.pmq.openwire.v3.PMQStreamMessageMarshaller;
import com.primeton.pmq.openwire.v3.PMQTempQueueMarshaller;
import com.primeton.pmq.openwire.v3.PMQTempTopicMarshaller;
import com.primeton.pmq.openwire.v3.PMQTextMessageMarshaller;
import com.primeton.pmq.openwire.v3.PMQTopicMarshaller;
import com.primeton.pmq.openwire.v3.PartialCommandMarshaller;
import com.primeton.pmq.openwire.v3.ProducerAckMarshaller;
import com.primeton.pmq.openwire.v3.ProducerIdMarshaller;
import com.primeton.pmq.openwire.v3.ProducerInfoMarshaller;
import com.primeton.pmq.openwire.v3.RemoveInfoMarshaller;
import com.primeton.pmq.openwire.v3.RemoveSubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v3.ReplayCommandMarshaller;
import com.primeton.pmq.openwire.v3.ResponseMarshaller;
import com.primeton.pmq.openwire.v3.SessionIdMarshaller;
import com.primeton.pmq.openwire.v3.SessionInfoMarshaller;
import com.primeton.pmq.openwire.v3.ShutdownInfoMarshaller;
import com.primeton.pmq.openwire.v3.SubscriptionInfoMarshaller;
import com.primeton.pmq.openwire.v3.TransactionInfoMarshaller;
import com.primeton.pmq.openwire.v3.WireFormatInfoMarshaller;
import com.primeton.pmq.openwire.v3.XATransactionIdMarshaller;

public final class MarshallerFactory {
    private static final DataStreamMarshaller[] MARSHALLER = new DataStreamMarshaller[256];

    private MarshallerFactory() {
    }

    private static void add(DataStreamMarshaller dsm) {
        MarshallerFactory.MARSHALLER[dsm.getDataStructureType()] = dsm;
    }

    public static DataStreamMarshaller[] createMarshallerMap(OpenWireFormat wireFormat) {
        return MARSHALLER;
    }

    static {
        MarshallerFactory.add(new PMQBlobMessageMarshaller());
        MarshallerFactory.add(new PMQBytesMessageMarshaller());
        MarshallerFactory.add(new PMQMapMessageMarshaller());
        MarshallerFactory.add(new PMQMessageMarshaller());
        MarshallerFactory.add(new PMQObjectMessageMarshaller());
        MarshallerFactory.add(new PMQQueueMarshaller());
        MarshallerFactory.add(new PMQStreamMessageMarshaller());
        MarshallerFactory.add(new PMQTempQueueMarshaller());
        MarshallerFactory.add(new PMQTempTopicMarshaller());
        MarshallerFactory.add(new PMQTextMessageMarshaller());
        MarshallerFactory.add(new PMQTopicMarshaller());
        MarshallerFactory.add(new BrokerIdMarshaller());
        MarshallerFactory.add(new BrokerInfoMarshaller());
        MarshallerFactory.add(new ConnectionControlMarshaller());
        MarshallerFactory.add(new ConnectionErrorMarshaller());
        MarshallerFactory.add(new ConnectionIdMarshaller());
        MarshallerFactory.add(new ConnectionInfoMarshaller());
        MarshallerFactory.add(new ConsumerControlMarshaller());
        MarshallerFactory.add(new ConsumerIdMarshaller());
        MarshallerFactory.add(new ConsumerInfoMarshaller());
        MarshallerFactory.add(new ControlCommandMarshaller());
        MarshallerFactory.add(new DataArrayResponseMarshaller());
        MarshallerFactory.add(new DataResponseMarshaller());
        MarshallerFactory.add(new DestinationInfoMarshaller());
        MarshallerFactory.add(new DiscoveryEventMarshaller());
        MarshallerFactory.add(new ExceptionResponseMarshaller());
        MarshallerFactory.add(new FlushCommandMarshaller());
        MarshallerFactory.add(new IntegerResponseMarshaller());
        MarshallerFactory.add(new JournalQueueAckMarshaller());
        MarshallerFactory.add(new JournalTopicAckMarshaller());
        MarshallerFactory.add(new JournalTraceMarshaller());
        MarshallerFactory.add(new JournalTransactionMarshaller());
        MarshallerFactory.add(new KeepAliveInfoMarshaller());
        MarshallerFactory.add(new LastPartialCommandMarshaller());
        MarshallerFactory.add(new LocalTransactionIdMarshaller());
        MarshallerFactory.add(new MessageAckMarshaller());
        MarshallerFactory.add(new MessageDispatchMarshaller());
        MarshallerFactory.add(new MessageDispatchNotificationMarshaller());
        MarshallerFactory.add(new MessageIdMarshaller());
        MarshallerFactory.add(new MessagePullMarshaller());
        MarshallerFactory.add(new NetworkBridgeFilterMarshaller());
        MarshallerFactory.add(new PartialCommandMarshaller());
        MarshallerFactory.add(new ProducerAckMarshaller());
        MarshallerFactory.add(new ProducerIdMarshaller());
        MarshallerFactory.add(new ProducerInfoMarshaller());
        MarshallerFactory.add(new RemoveInfoMarshaller());
        MarshallerFactory.add(new RemoveSubscriptionInfoMarshaller());
        MarshallerFactory.add(new ReplayCommandMarshaller());
        MarshallerFactory.add(new ResponseMarshaller());
        MarshallerFactory.add(new SessionIdMarshaller());
        MarshallerFactory.add(new SessionInfoMarshaller());
        MarshallerFactory.add(new ShutdownInfoMarshaller());
        MarshallerFactory.add(new SubscriptionInfoMarshaller());
        MarshallerFactory.add(new TransactionInfoMarshaller());
        MarshallerFactory.add(new WireFormatInfoMarshaller());
        MarshallerFactory.add(new XATransactionIdMarshaller());
    }
}

