/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.openwire.v9;

import com.primeton.pmq.command.BrokerId;
import com.primeton.pmq.command.ConnectionId;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.command.DataStructure;
import com.primeton.pmq.openwire.BooleanStream;
import com.primeton.pmq.openwire.OpenWireFormat;
import com.primeton.pmq.openwire.v9.BaseCommandMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConnectionInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 3;
    }

    @Override
    public DataStructure createObject() {
        return new ConnectionInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ConnectionInfo info = (ConnectionInfo)o;
        info.setConnectionId((ConnectionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setClientId(this.tightUnmarshalString(dataIn, bs));
        info.setPassword(this.tightUnmarshalString(dataIn, bs));
        info.setUserName(this.tightUnmarshalString(dataIn, bs));
        if (bs.readBoolean()) {
            int size2 = dataIn.readShort();
            BrokerId[] value = new BrokerId[size2];
            for (int i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setBrokerPath(value);
        } else {
            info.setBrokerPath(null);
        }
        info.setBrokerMasterConnector(bs.readBoolean());
        info.setManageable(bs.readBoolean());
        info.setClientMaster(bs.readBoolean());
        info.setFaultTolerant(bs.readBoolean());
        info.setFailoverReconnect(bs.readBoolean());
        info.setClientIp(this.tightUnmarshalString(dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConnectionInfo info = (ConnectionInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getConnectionId(), bs);
        rc += this.tightMarshalString1(info.getClientId(), bs);
        rc += this.tightMarshalString1(info.getPassword(), bs);
        rc += this.tightMarshalString1(info.getUserName(), bs);
        rc += this.tightMarshalObjectArray1(wireFormat, info.getBrokerPath(), bs);
        bs.writeBoolean(info.isBrokerMasterConnector());
        bs.writeBoolean(info.isManageable());
        bs.writeBoolean(info.isClientMaster());
        bs.writeBoolean(info.isFaultTolerant());
        bs.writeBoolean(info.isFailoverReconnect());
        return (rc += this.tightMarshalString1(info.getClientIp(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ConnectionInfo info = (ConnectionInfo)o;
        this.tightMarshalCachedObject2(wireFormat, info.getConnectionId(), dataOut, bs);
        this.tightMarshalString2(info.getClientId(), dataOut, bs);
        this.tightMarshalString2(info.getPassword(), dataOut, bs);
        this.tightMarshalString2(info.getUserName(), dataOut, bs);
        this.tightMarshalObjectArray2(wireFormat, info.getBrokerPath(), dataOut, bs);
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        this.tightMarshalString2(info.getClientIp(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ConnectionInfo info = (ConnectionInfo)o;
        info.setConnectionId((ConnectionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setClientId(this.looseUnmarshalString(dataIn));
        info.setPassword(this.looseUnmarshalString(dataIn));
        info.setUserName(this.looseUnmarshalString(dataIn));
        if (dataIn.readBoolean()) {
            int size2 = dataIn.readShort();
            BrokerId[] value = new BrokerId[size2];
            for (int i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info.setBrokerPath(value);
        } else {
            info.setBrokerPath(null);
        }
        info.setBrokerMasterConnector(dataIn.readBoolean());
        info.setManageable(dataIn.readBoolean());
        info.setClientMaster(dataIn.readBoolean());
        info.setFaultTolerant(dataIn.readBoolean());
        info.setFailoverReconnect(dataIn.readBoolean());
        info.setClientIp(this.looseUnmarshalString(dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ConnectionInfo info = (ConnectionInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getConnectionId(), dataOut);
        this.looseMarshalString(info.getClientId(), dataOut);
        this.looseMarshalString(info.getPassword(), dataOut);
        this.looseMarshalString(info.getUserName(), dataOut);
        this.looseMarshalObjectArray(wireFormat, info.getBrokerPath(), dataOut);
        dataOut.writeBoolean(info.isBrokerMasterConnector());
        dataOut.writeBoolean(info.isManageable());
        dataOut.writeBoolean(info.isClientMaster());
        dataOut.writeBoolean(info.isFaultTolerant());
        dataOut.writeBoolean(info.isFailoverReconnect());
        this.looseMarshalString(info.getClientIp(), dataOut);
    }
}

