/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.plugin;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.jmx.BrokerViewMBean;
import com.primeton.pmq.broker.jmx.SubscriptionViewMBean;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationStatistics;
import com.primeton.pmq.broker.region.RegionBroker;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.MessageId;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMapMessage;
import com.primeton.pmq.command.ProducerId;
import com.primeton.pmq.command.ProducerInfo;
import com.primeton.pmq.state.ProducerState;
import com.primeton.pmq.usage.SystemUsage;
import com.primeton.pmq.util.IdGenerator;
import com.primeton.pmq.util.LongSequenceGenerator;
import java.io.File;
import java.net.URI;
import java.util.Set;
import javax.jms.JMSException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsBroker
extends BrokerFilter {
    private static Logger LOG = LoggerFactory.getLogger(StatisticsBroker.class);
    static final String STATS_DESTINATION_PREFIX = "PMQ.Statistics.Destination";
    static final String STATS_BROKER_PREFIX = "PMQ.Statistics.Broker";
    static final String STATS_BROKER_RESET_HEADER = "PMQ.Statistics.Broker.Reset";
    static final String STATS_SUBSCRIPTION_PREFIX = "PMQ.Statistics.Subscription";
    static final String STATS_DENOTE_END_LIST = "PMQ.Statistics.Destination.List.End.With.Null";
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    protected final ProducerId advisoryProducerId = new ProducerId();
    protected BrokerViewMBean brokerView;

    public StatisticsBroker(Broker next) {
        super(next);
        this.advisoryProducerId.setConnectionId(ID_GENERATOR.generateId());
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        PMQDestination msgDest = messageSend.getDestination();
        PMQDestination replyTo = messageSend.getReplyTo();
        if (replyTo != null) {
            String physicalName = msgDest.getPhysicalName();
            boolean destStats = physicalName.regionMatches(true, 0, STATS_DESTINATION_PREFIX, 0, STATS_DESTINATION_PREFIX.length());
            boolean brokerStats = physicalName.regionMatches(true, 0, STATS_BROKER_PREFIX, 0, STATS_BROKER_PREFIX.length());
            boolean subStats = physicalName.regionMatches(true, 0, STATS_SUBSCRIPTION_PREFIX, 0, STATS_SUBSCRIPTION_PREFIX.length());
            BrokerService brokerService = this.getBrokerService();
            RegionBroker regionBroker = (RegionBroker)brokerService.getRegionBroker();
            if (destStats) {
                String destinationQuery;
                String destinationName = physicalName.substring(STATS_DESTINATION_PREFIX.length(), physicalName.length());
                if (destinationName.startsWith(".")) {
                    destinationName = destinationName.substring(1);
                }
                boolean endListMessage = !destinationName.equals(destinationQuery = destinationName.replace(STATS_DENOTE_END_LIST, ""));
                PMQDestination queryDestination = PMQDestination.createDestination(destinationQuery, msgDest.getDestinationType());
                Set<Destination> destinations = this.getDestinations(queryDestination);
                for (Destination dest : destinations) {
                    DestinationStatistics stats = dest.getDestinationStatistics();
                    if (stats == null) continue;
                    PMQMapMessage statsMessage = new PMQMapMessage();
                    statsMessage.setString("brokerName", regionBroker.getBrokerName());
                    statsMessage.setString("brokerId", regionBroker.getBrokerId().toString());
                    statsMessage.setString("destinationName", dest.getPMQDestination().toString());
                    statsMessage.setLong("size", stats.getMessages().getCount());
                    statsMessage.setLong("enqueueCount", stats.getEnqueues().getCount());
                    statsMessage.setLong("dequeueCount", stats.getDequeues().getCount());
                    statsMessage.setLong("dispatchCount", stats.getDispatched().getCount());
                    statsMessage.setLong("expiredCount", stats.getExpired().getCount());
                    statsMessage.setLong("inflightCount", stats.getInflight().getCount());
                    statsMessage.setLong("messagesCached", stats.getMessagesCached().getCount());
                    statsMessage.setLong("averageMessageSize", (long)stats.getMessageSize().getAverageSize());
                    statsMessage.setInt("memoryPercentUsage", dest.getMemoryUsage().getPercentUsage());
                    statsMessage.setLong("memoryUsage", dest.getMemoryUsage().getUsage());
                    statsMessage.setLong("memoryLimit", dest.getMemoryUsage().getLimit());
                    statsMessage.setDouble("averageEnqueueTime", stats.getProcessTime().getAverageTime());
                    statsMessage.setDouble("maxEnqueueTime", stats.getProcessTime().getMaxTime());
                    statsMessage.setDouble("minEnqueueTime", stats.getProcessTime().getMinTime());
                    statsMessage.setLong("consumerCount", stats.getConsumers().getCount());
                    statsMessage.setLong("producerCount", stats.getProducers().getCount());
                    statsMessage.setJMSCorrelationID(messageSend.getCorrelationId());
                    this.sendStats(producerExchange.getConnectionContext(), statsMessage, replyTo);
                }
                if (endListMessage) {
                    PMQMapMessage statsMessage = new PMQMapMessage();
                    statsMessage.setJMSCorrelationID(messageSend.getCorrelationId());
                    this.sendStats(producerExchange.getConnectionContext(), statsMessage, replyTo);
                }
            } else if (subStats) {
                this.sendSubStats(producerExchange.getConnectionContext(), this.getBrokerView().getQueueSubscribers(), replyTo);
                this.sendSubStats(producerExchange.getConnectionContext(), this.getBrokerView().getTopicSubscribers(), replyTo);
            } else if (brokerStats) {
                if (messageSend.getProperties().containsKey(STATS_BROKER_RESET_HEADER)) {
                    this.getBrokerView().resetStatistics();
                }
                PMQMapMessage statsMessage = new PMQMapMessage();
                SystemUsage systemUsage = brokerService.getSystemUsage();
                DestinationStatistics stats = regionBroker.getDestinationStatistics();
                statsMessage.setString("brokerName", regionBroker.getBrokerName());
                statsMessage.setString("brokerId", regionBroker.getBrokerId().toString());
                statsMessage.setLong("size", stats.getMessages().getCount());
                statsMessage.setLong("enqueueCount", stats.getEnqueues().getCount());
                statsMessage.setLong("dequeueCount", stats.getDequeues().getCount());
                statsMessage.setLong("dispatchCount", stats.getDispatched().getCount());
                statsMessage.setLong("expiredCount", stats.getExpired().getCount());
                statsMessage.setLong("inflightCount", stats.getInflight().getCount());
                statsMessage.setLong("averageMessageSize", (long)stats.getMessageSize().getAverageSize());
                statsMessage.setLong("messagesCached", stats.getMessagesCached().getCount());
                statsMessage.setInt("memoryPercentUsage", systemUsage.getMemoryUsage().getPercentUsage());
                statsMessage.setLong("memoryUsage", systemUsage.getMemoryUsage().getUsage());
                statsMessage.setLong("memoryLimit", systemUsage.getMemoryUsage().getLimit());
                statsMessage.setInt("storePercentUsage", systemUsage.getStoreUsage().getPercentUsage());
                statsMessage.setLong("storeUsage", systemUsage.getStoreUsage().getUsage());
                statsMessage.setLong("storeLimit", systemUsage.getStoreUsage().getLimit());
                statsMessage.setInt("tempPercentUsage", systemUsage.getTempUsage().getPercentUsage());
                statsMessage.setLong("tempUsage", systemUsage.getTempUsage().getUsage());
                statsMessage.setLong("tempLimit", systemUsage.getTempUsage().getLimit());
                statsMessage.setDouble("averageEnqueueTime", stats.getProcessTime().getAverageTime());
                statsMessage.setDouble("maxEnqueueTime", stats.getProcessTime().getMaxTime());
                statsMessage.setDouble("minEnqueueTime", stats.getProcessTime().getMinTime());
                statsMessage.setLong("consumerCount", stats.getConsumers().getCount());
                statsMessage.setLong("producerCount", stats.getProducers().getCount());
                String answer = brokerService.getTransportConnectorURIsAsMap().get("tcp");
                answer = answer != null ? answer : "";
                statsMessage.setString("openwire", answer);
                answer = brokerService.getTransportConnectorURIsAsMap().get("stomp");
                answer = answer != null ? answer : "";
                statsMessage.setString("stomp", answer);
                answer = brokerService.getTransportConnectorURIsAsMap().get("ssl");
                answer = answer != null ? answer : "";
                statsMessage.setString("ssl", answer);
                answer = brokerService.getTransportConnectorURIsAsMap().get("stomp+ssl");
                answer = answer != null ? answer : "";
                statsMessage.setString("stomp+ssl", answer);
                URI uri = brokerService.getVmConnectorURI();
                answer = uri != null ? uri.toString() : "";
                statsMessage.setString("vm", answer);
                File file = brokerService.getDataDirectoryFile();
                answer = file != null ? file.getCanonicalPath() : "";
                statsMessage.setString("dataDirectory", answer);
                statsMessage.setJMSCorrelationID(messageSend.getCorrelationId());
                this.sendStats(producerExchange.getConnectionContext(), statsMessage, replyTo);
            } else {
                super.send(producerExchange, messageSend);
            }
        } else {
            super.send(producerExchange, messageSend);
        }
    }

    BrokerViewMBean getBrokerView() throws Exception {
        if (this.brokerView == null) {
            ObjectName brokerName = this.getBrokerService().getBrokerObjectName();
            this.brokerView = (BrokerViewMBean)this.getBrokerService().getManagementContext().newProxyInstance(brokerName, BrokerViewMBean.class, true);
        }
        return this.brokerView;
    }

    @Override
    public void start() throws Exception {
        super.start();
        LOG.info("Starting StatisticsBroker");
    }

    @Override
    public void stop() throws Exception {
        super.stop();
    }

    protected void sendSubStats(ConnectionContext context, ObjectName[] subscribers, PMQDestination replyTo) throws Exception {
        for (int i = 0; i < subscribers.length; ++i) {
            ObjectName name = subscribers[i];
            SubscriptionViewMBean subscriber = (SubscriptionViewMBean)this.getBrokerService().getManagementContext().newProxyInstance(name, SubscriptionViewMBean.class, true);
            PMQMapMessage statsMessage = this.prepareSubscriptionMessage(subscriber);
            this.sendStats(context, statsMessage, replyTo);
        }
    }

    protected PMQMapMessage prepareSubscriptionMessage(SubscriptionViewMBean subscriber) throws JMSException {
        Broker regionBroker = this.getBrokerService().getRegionBroker();
        PMQMapMessage statsMessage = new PMQMapMessage();
        statsMessage.setString("brokerName", regionBroker.getBrokerName());
        statsMessage.setString("brokerId", regionBroker.getBrokerId().toString());
        statsMessage.setString("destinationName", subscriber.getDestinationName());
        statsMessage.setString("clientId", subscriber.getClientId());
        statsMessage.setString("connectionId", subscriber.getConnectionId());
        statsMessage.setLong("sessionId", subscriber.getSessionId());
        statsMessage.setString("selector", subscriber.getSelector());
        statsMessage.setLong("enqueueCounter", subscriber.getEnqueueCounter());
        statsMessage.setLong("dequeueCounter", subscriber.getDequeueCounter());
        statsMessage.setLong("dispatchedCounter", subscriber.getDispatchedCounter());
        statsMessage.setLong("dispatchedQueueSize", subscriber.getDispatchedQueueSize());
        statsMessage.setInt("prefetchSize", subscriber.getPrefetchSize());
        statsMessage.setInt("maximumPendingMessageLimit", subscriber.getMaximumPendingMessageLimit());
        statsMessage.setBoolean("exclusive", subscriber.isExclusive());
        statsMessage.setBoolean("retroactive", subscriber.isRetroactive());
        statsMessage.setBoolean("slowConsumer", subscriber.isSlowConsumer());
        return statsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStats(ConnectionContext context, PMQMapMessage msg, PMQDestination replyTo) throws Exception {
        msg.setPersistent(false);
        msg.setTimestamp(System.currentTimeMillis());
        msg.setPriority((byte)4);
        msg.setType("Advisory");
        msg.setMessageId(new MessageId(this.advisoryProducerId, this.messageIdGenerator.getNextSequenceId()));
        msg.setDestination(replyTo);
        msg.setResponseRequired(false);
        msg.setProducerId(this.advisoryProducerId);
        boolean originalFlowControl = context.isProducerFlowControl();
        ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
        producerExchange.setConnectionContext(context);
        producerExchange.setMutable(true);
        producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
        try {
            context.setProducerFlowControl(false);
            this.next.send(producerExchange, msg);
        }
        finally {
            context.setProducerFlowControl(originalFlowControl);
        }
    }
}

