/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.pool;

import com.primeton.pmq.PMQConnection;
import com.primeton.pmq.PMQConnectionFactory;
import com.primeton.pmq.PMQSession;
import com.primeton.pmq.PMQXAConnectionFactory;
import com.primeton.pmq.Service;
import com.primeton.pmq.jms.pool.ConnectionPool;
import com.primeton.pmq.jms.pool.PooledSession;
import com.primeton.pmq.jms.pool.SessionKey;
import com.primeton.pmq.jms.pool.XaConnectionPool;
import com.primeton.pmq.jndi.JNDIReferenceFactory;
import com.primeton.pmq.jndi.JNDIStorableInterface;
import com.primeton.pmq.transport.TransportListener;
import com.primeton.pmq.util.IntrospectionSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XaPooledConnectionFactory
extends com.primeton.pmq.jms.pool.XaPooledConnectionFactory
implements JNDIStorableInterface,
Service {
    public static final String POOL_PROPS_PREFIX = "pool";
    private static final transient Logger LOG = LoggerFactory.getLogger(com.primeton.pmq.jms.pool.XaPooledConnectionFactory.class);
    private String brokerUrl;

    public XaPooledConnectionFactory() {
    }

    public XaPooledConnectionFactory(PMQXAConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    @Override
    protected ConnectionPool createConnectionPool(Connection connection) {
        return new XaConnectionPool(connection, this.getTransactionManager()){

            @Override
            protected Session makeSession(SessionKey key) throws JMSException {
                if (this.connection instanceof XAConnection) {
                    return ((XAConnection)this.connection).createXASession();
                }
                return this.connection.createSession(key.isTransacted(), key.getAckMode());
            }

            @Override
            protected XAResource createXaResource(PooledSession session) throws JMSException {
                if (session.getInternalSession() instanceof XASession) {
                    return ((XASession)session.getInternalSession()).getXAResource();
                }
                return ((PMQSession)session.getInternalSession()).getTransactionContext();
            }

            @Override
            protected Connection wrap(final Connection connection) {
                ((PMQConnection)connection).addTransportListener(new TransportListener(){

                    @Override
                    public void onCommand(Object command) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onException(IOException error) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.setHasExpired(true);
                            if (!XaPooledConnectionFactory.this.stopped.get()) {
                                LOG.info("Expiring connection " + connection + " on IOException: " + error.getMessage());
                                LOG.debug("Expiring connection " + connection + " on IOException: ", error);
                            }
                        }
                    }

                    @Override
                    public void transportInterupted() {
                    }

                    @Override
                    public void transportResumed() {
                    }
                });
                this.setHasExpired(((PMQConnection)connection).isTransportFailed());
                return connection;
            }

            @Override
            protected void unWrap(Connection connection) {
                if (connection != null) {
                    ((PMQConnection)connection).cleanUpTempDestinations();
                }
            }
        };
    }

    protected void buildFromProperties(Properties props) {
        PMQConnectionFactory pmqConnectionFactory = props.containsKey("xaAckMode") ? new PMQXAConnectionFactory() : new PMQConnectionFactory();
        pmqConnectionFactory.buildFromProperties(props);
        this.setConnectionFactory(pmqConnectionFactory);
        IntrospectionSupport.setProperties((Object)this, new HashMap<Object, Object>(props), POOL_PROPS_PREFIX);
    }

    @Override
    protected void populateProperties(Properties props) {
        ((PMQConnectionFactory)this.getConnectionFactory()).populateProperties(props);
        IntrospectionSupport.getProperties(this, props, POOL_PROPS_PREFIX);
    }

    @Override
    public void setProperties(Properties properties) {
        this.buildFromProperties(properties);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        this.populateProperties(properties);
        return properties;
    }

    @Override
    public Reference getReference() throws NamingException {
        return JNDIReferenceFactory.createReference(this.getClass().getName(), this);
    }

    public void setBrokerUrl(String url) {
        if (this.brokerUrl == null || !this.brokerUrl.equals(url)) {
            this.brokerUrl = url;
            this.setConnectionFactory(new PMQXAConnectionFactory(this.brokerUrl));
        }
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }
}

