/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.protobuf;

import com.primeton.pmq.protobuf.BaseMessage;
import com.primeton.pmq.protobuf.Buffer;
import com.primeton.pmq.protobuf.CodedInputStream;
import com.primeton.pmq.protobuf.InvalidProtocolBufferException;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeferredDecodeMessage<T>
extends BaseMessage<T> {
    protected Buffer encodedForm;
    protected boolean decoded = true;

    @Override
    public T mergeFramed(CodedInputStream input) throws IOException {
        int length = input.readRawVarint32();
        int oldLimit = input.pushLimit(length);
        T rc = this.mergeUnframed(input.readRawBytes(length));
        input.popLimit(oldLimit);
        return rc;
    }

    @Override
    public T mergeUnframed(Buffer data) throws InvalidProtocolBufferException {
        this.encodedForm = data;
        this.decoded = false;
        return (T)this;
    }

    @Override
    public Buffer toUnframedBuffer() {
        if (this.encodedForm == null) {
            this.encodedForm = super.toUnframedBuffer();
        }
        return this.encodedForm;
    }

    @Override
    protected void load() {
        if (!this.decoded) {
            this.decoded = true;
            try {
                Buffer originalForm = this.encodedForm;
                this.encodedForm = null;
                CodedInputStream input = new CodedInputStream(originalForm);
                this.mergeUnframed(input);
                input.checkLastTagWas(0);
                this.encodedForm = originalForm;
                this.checktInitialized();
            }
            catch (Throwable e) {
                throw new RuntimeException("Deferred message decoding failed: " + e.getMessage(), e);
            }
        }
    }

    @Override
    protected void loadAndClear() {
        super.loadAndClear();
        this.load();
        this.encodedForm = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.encodedForm = null;
        this.decoded = true;
    }

    public boolean isDecoded() {
        return this.decoded;
    }

    public boolean isEncoded() {
        return this.encodedForm != null;
    }
}

