/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.region.CompositeDestinationInterceptor;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationInterceptor;
import com.primeton.pmq.broker.region.RegionBroker;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.DestinationInfo;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.ProducerInfo;
import com.primeton.pmq.security.AuthorizationDestinationInterceptor;
import com.primeton.pmq.security.AuthorizationMap;
import com.primeton.pmq.security.SecurityAdminMBean;
import com.primeton.pmq.security.SecurityContext;
import java.util.Arrays;
import java.util.Set;

public class AuthorizationBroker
extends BrokerFilter
implements SecurityAdminMBean {
    private volatile AuthorizationMap authorizationMap;

    public AuthorizationBroker(Broker next, AuthorizationMap authorizationMap) {
        super(next);
        this.authorizationMap = authorizationMap;
        RegionBroker regionBroker = (RegionBroker)next.getAdaptor(RegionBroker.class);
        CompositeDestinationInterceptor compositeInterceptor = (CompositeDestinationInterceptor)regionBroker.getDestinationInterceptor();
        DestinationInterceptor[] interceptors = compositeInterceptor.getInterceptors();
        interceptors = Arrays.copyOf(interceptors, interceptors.length + 1);
        interceptors[interceptors.length - 1] = new AuthorizationDestinationInterceptor(this);
        compositeInterceptor.setInterceptors(interceptors);
    }

    public AuthorizationMap getAuthorizationMap() {
        return this.authorizationMap;
    }

    public void setAuthorizationMap(AuthorizationMap map) {
        this.authorizationMap = map;
    }

    protected SecurityContext checkSecurityContext(ConnectionContext context) throws SecurityException {
        SecurityContext securityContext = context.getSecurityContext();
        if (securityContext == null) {
            throw new SecurityException("User is not authenticated.");
        }
        return securityContext;
    }

    protected boolean checkDestinationAdmin(SecurityContext securityContext, PMQDestination destination) {
        Destination existing = this.getDestinationMap(destination).get(destination);
        if (existing != null) {
            return true;
        }
        if (!securityContext.isBrokerContext()) {
            Set<?> allowedACLs = null;
            allowedACLs = !destination.isTemporary() ? this.authorizationMap.getAdminACLs(destination) : this.authorizationMap.getTempDestinationAdminACLs();
            if (allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        SecurityContext securityContext = this.checkSecurityContext(context);
        if (!this.checkDestinationAdmin(securityContext, info.getDestination())) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to create: " + info.getDestination());
        }
        super.addDestinationInfo(context, info);
    }

    @Override
    public Destination addDestination(ConnectionContext context, PMQDestination destination, boolean create) throws Exception {
        SecurityContext securityContext = this.checkSecurityContext(context);
        if (!this.checkDestinationAdmin(securityContext, destination)) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to create: " + destination);
        }
        return super.addDestination(context, destination, create);
    }

    @Override
    public void removeDestination(ConnectionContext context, PMQDestination destination, long timeout) throws Exception {
        SecurityContext securityContext = this.checkSecurityContext(context);
        if (!this.checkDestinationAdmin(securityContext, destination)) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to remove: " + destination);
        }
        securityContext.getAuthorizedWriteDests().remove(destination);
        super.removeDestination(context, destination, timeout);
    }

    @Override
    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        SecurityContext securityContext = this.checkSecurityContext(context);
        if (!this.checkDestinationAdmin(securityContext, info.getDestination())) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to remove: " + info.getDestination());
        }
        securityContext.getAuthorizedWriteDests().remove(info.getDestination());
        super.removeDestinationInfo(context, info);
    }

    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        SecurityContext securityContext = this.checkSecurityContext(context);
        Set<?> allowedACLs = null;
        allowedACLs = !info.getDestination().isTemporary() ? this.authorizationMap.getReadACLs(info.getDestination()) : this.authorizationMap.getTempDestinationReadACLs();
        if (!securityContext.isBrokerContext() && allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
            throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to read from: " + info.getDestination());
        }
        return super.addConsumer(context, info);
    }

    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        SecurityContext securityContext = this.checkSecurityContext(context);
        if (!securityContext.isBrokerContext() && info.getDestination() != null) {
            Set<?> allowedACLs = null;
            allowedACLs = !info.getDestination().isTemporary() ? this.authorizationMap.getWriteACLs(info.getDestination()) : this.authorizationMap.getTempDestinationWriteACLs();
            if (allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to write to: " + info.getDestination());
            }
            securityContext.getAuthorizedWriteDests().put(info.getDestination(), info.getDestination());
        }
        super.addProducer(context, info);
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        SecurityContext securityContext = this.checkSecurityContext(producerExchange.getConnectionContext());
        if (!securityContext.isBrokerContext() && !securityContext.getAuthorizedWriteDests().containsValue(messageSend.getDestination())) {
            Set<?> allowedACLs = null;
            allowedACLs = !messageSend.getDestination().isTemporary() ? this.authorizationMap.getWriteACLs(messageSend.getDestination()) : this.authorizationMap.getTempDestinationWriteACLs();
            if (allowedACLs != null && !securityContext.isInOneOf(allowedACLs)) {
                throw new SecurityException("User " + securityContext.getUserName() + " is not authorized to write to: " + messageSend.getDestination());
            }
            securityContext.getAuthorizedWriteDests().put(messageSend.getDestination(), messageSend.getDestination());
        }
        super.send(producerExchange, messageSend);
    }

    @Override
    public void addQueueRole(String queue2, String operation, String role) {
        this.addDestinationRole(new PMQQueue(queue2), operation, role);
    }

    @Override
    public void addTopicRole(String topic, String operation, String role) {
        this.addDestinationRole(new PMQTopic(topic), operation, role);
    }

    @Override
    public void removeQueueRole(String queue2, String operation, String role) {
        this.removeDestinationRole(new PMQQueue(queue2), operation, role);
    }

    @Override
    public void removeTopicRole(String topic, String operation, String role) {
        this.removeDestinationRole(new PMQTopic(topic), operation, role);
    }

    public void addDestinationRole(javax.jms.Destination destination, String operation, String role) {
    }

    public void removeDestinationRole(javax.jms.Destination destination, String operation, String role) {
    }

    @Override
    public void addRole(String role) {
    }

    @Override
    public void addUserRole(String user, String role) {
    }

    @Override
    public void removeRole(String role) {
    }

    @Override
    public void removeUserRole(String user, String role) {
    }
}

