/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerPlugin;
import com.primeton.pmq.security.JaasAuthenticationBroker;
import java.net.URL;

public class JaasAuthenticationPlugin
implements BrokerPlugin {
    protected String configuration = "pmq-domain";
    protected boolean discoverLoginConfig = true;

    @Override
    public Broker installPlugin(Broker broker) {
        this.initialiseJaas();
        return new JaasAuthenticationBroker(broker, this.configuration);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String jaasConfiguration) {
        this.configuration = jaasConfiguration;
    }

    public boolean isDiscoverLoginConfig() {
        return this.discoverLoginConfig;
    }

    public void setDiscoverLoginConfig(boolean discoverLoginConfig) {
        this.discoverLoginConfig = discoverLoginConfig;
    }

    protected void initialiseJaas() {
        String path;
        if (this.discoverLoginConfig && (path = System.getProperty("java.security.auth.login.config")) == null) {
            URL resource = null;
            if (resource == null) {
                resource = this.getClass().getClassLoader().getResource("login.config");
            }
            if (resource != null) {
                path = resource.getFile();
                System.setProperty("java.security.auth.login.config", path);
            }
        }
    }
}

