/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.jaas.JaasCertificateCallbackHandler;
import com.primeton.pmq.jaas.UserPrincipal;
import com.primeton.pmq.security.AuthenticationBroker;
import com.primeton.pmq.security.JaasAuthenticationBroker;
import com.primeton.pmq.security.JaasCertificateSecurityContext;
import com.primeton.pmq.security.SecurityContext;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;

public class JaasCertificateAuthenticationBroker
extends BrokerFilter
implements AuthenticationBroker {
    private final String jaasConfiguration;

    public JaasCertificateAuthenticationBroker(Broker next, String jaasConfiguration) {
        super(next);
        this.jaasConfiguration = jaasConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        if (context.getSecurityContext() == null) {
            if (!(info.getTransportContext() instanceof X509Certificate[])) {
                throw new SecurityException("Unable to authenticate transport without SSL certificate.");
            }
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(JaasAuthenticationBroker.class.getClassLoader());
            try {
                SecurityContext s = this.authenticate(info.getUserName(), info.getPassword(), (X509Certificate[])info.getTransportContext());
                context.setSecurityContext(s);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        super.addConnection(context, info);
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        context.setSecurityContext(null);
    }

    @Override
    public SecurityContext authenticate(String username, String password, X509Certificate[] peerCertificates) throws SecurityException {
        try {
            JaasCertificateCallbackHandler callback = new JaasCertificateCallbackHandler(peerCertificates);
            LoginContext lc = new LoginContext(this.jaasConfiguration, (CallbackHandler)callback);
            lc.login();
            Subject subject = lc.getSubject();
            String dnName = "";
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof UserPrincipal)) continue;
                dnName = ((UserPrincipal)principal).getName();
                break;
            }
            return new JaasCertificateSecurityContext(dnName, subject, peerCertificates);
        }
        catch (Exception e) {
            throw new SecurityException("User name [" + username + "] or password is invalid. " + e.getMessage(), e);
        }
    }
}

