/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.Connector;
import com.primeton.pmq.broker.EmptyBroker;
import com.primeton.pmq.broker.TransportConnector;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.security.AuthenticationBroker;
import com.primeton.pmq.security.JaasAuthenticationBroker;
import com.primeton.pmq.security.JaasCertificateAuthenticationBroker;
import com.primeton.pmq.security.SecurityContext;
import java.security.cert.X509Certificate;

public class JaasDualAuthenticationBroker
extends BrokerFilter
implements AuthenticationBroker {
    private final JaasCertificateAuthenticationBroker sslBroker;
    private final JaasAuthenticationBroker nonSslBroker;

    public JaasDualAuthenticationBroker(Broker next, String jaasConfiguration, String jaasSslConfiguration) {
        super(next);
        this.nonSslBroker = new JaasAuthenticationBroker(new EmptyBroker(), jaasConfiguration);
        this.sslBroker = new JaasCertificateAuthenticationBroker(new EmptyBroker(), jaasSslConfiguration);
    }

    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        if (context.getSecurityContext() == null) {
            if (this.isSSL(context, info)) {
                this.sslBroker.addConnection(context, info);
            } else {
                this.nonSslBroker.addConnection(context, info);
            }
            super.addConnection(context, info);
        }
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        if (this.isSSL(context, info)) {
            this.sslBroker.removeConnection(context, info, error);
        } else {
            this.nonSslBroker.removeConnection(context, info, error);
        }
    }

    private boolean isSSL(ConnectionContext context, ConnectionInfo info) throws Exception {
        boolean sslCapable = false;
        Connector connector = context.getConnector();
        if (connector instanceof TransportConnector) {
            TransportConnector transportConnector = (TransportConnector)connector;
            sslCapable = transportConnector.getServer().isSslServer();
        }
        if (!sslCapable && info.getTransportContext() instanceof X509Certificate[]) {
            sslCapable = true;
        }
        return sslCapable;
    }

    @Override
    public void removeDestination(ConnectionContext context, PMQDestination destination, long timeout) throws Exception {
        this.sslBroker.removeDestination(context, destination, timeout);
        this.nonSslBroker.removeDestination(context, destination, timeout);
        super.removeDestination(context, destination, timeout);
    }

    @Override
    public SecurityContext authenticate(String username, String password, X509Certificate[] peerCertificates) throws SecurityException {
        if (peerCertificates != null) {
            return this.sslBroker.authenticate(username, password, peerCertificates);
        }
        return this.nonSslBroker.authenticate(username, password, peerCertificates);
    }
}

