/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security;

import com.primeton.pmq.command.PMQDestination;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public abstract class SecurityContext {
    public static final SecurityContext BROKER_SECURITY_CONTEXT = new SecurityContext("PMQBroker"){

        @Override
        public boolean isBrokerContext() {
            return true;
        }

        @Override
        public Set<Principal> getPrincipals() {
            return Collections.emptySet();
        }
    };
    final String userName;
    final ConcurrentMap<PMQDestination, PMQDestination> authorizedWriteDests = new ConcurrentHashMap<PMQDestination, PMQDestination>();

    public SecurityContext(String userName) {
        this.userName = userName;
    }

    public boolean isInOneOf(Set<?> allowedPrincipals) {
        Iterator<?> allowedIter = allowedPrincipals.iterator();
        HashSet<Principal> userPrincipals = new HashSet<Principal>(this.getPrincipals());
        while (allowedIter.hasNext()) {
            Iterator<Principal> userIter = userPrincipals.iterator();
            Object allowedPrincipal = allowedIter.next();
            while (userIter.hasNext()) {
                Principal userPrincipal = userIter.next();
                if (allowedPrincipal.equals(userPrincipal)) {
                    return true;
                }
                if (!allowedPrincipal.getClass().equals(userPrincipal.getClass()) || !(allowedPrincipal instanceof Principal)) continue;
                Principal allowed = (Principal)allowedPrincipal;
                Principal user = userPrincipal;
                if ("*".equals(allowed.getName())) {
                    return true;
                }
                if (!Pattern.matches(allowed.getName(), user.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Set<Principal> getPrincipals();

    public String getUserName() {
        return this.userName;
    }

    public ConcurrentMap<PMQDestination, PMQDestination> getAuthorizedWriteDests() {
        return this.authorizedWriteDests;
    }

    public boolean isBrokerContext() {
        return false;
    }
}

