/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security.pmq;

import com.primeton.pmq.filter.DestinationMapEntry;
import com.primeton.pmq.jaas.GroupPrincipal;
import com.primeton.pmq.security.DefaultAuthorizationMap;
import com.primeton.pmq.security.pmq.AuthenticationAuthorizationEntryFactory;
import com.primeton.pmq.security.pmq.AuthorizationEntryAdaptor;
import com.primeton.pmq.security.pmq.AuthorizationManagerMBean;
import com.primeton.pmq.security.pmq.TempDestinationAuthorizationAdaptor;
import com.primeton.pmq.security.pmq.dto.PMQAuthorizationEntry;
import com.primeton.pmq.security.pmq.dto.PMQQueueAuthorizationEntry;
import com.primeton.pmq.security.pmq.dto.PMQTopicAuthorizationEntry;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class AuthorizationManager
extends DefaultAuthorizationMap
implements AuthorizationManagerMBean {
    private static final String TOPIC_PREFIX = "topic://";
    private static final String QUEUE_PREFIX = "queue://";
    private final AuthenticationAuthorizationEntryFactory factory;

    public AuthorizationManager(AuthenticationAuthorizationEntryFactory factory) {
        this.factory = factory;
        this.reload();
    }

    @Override
    public synchronized void reload() {
        this.factory.load();
        this.reset();
        Map<String, PMQAuthorizationEntry> authorizations = this.factory.getAuthcAuthzEntry().getAuthorizations();
        PMQAuthorizationEntry tempDestinationAuthorizationEntry = this.factory.getAuthcAuthzEntry().getTempDestinationAuthorizationEntry();
        List<DestinationMapEntry> authzList = authorizations.values().stream().map(AuthorizationEntryAdaptor::new).collect(Collectors.toList());
        this.setEntries(authzList);
        if (tempDestinationAuthorizationEntry != null) {
            this.setTempDestinationAuthorizationEntry(new TempDestinationAuthorizationAdaptor(tempDestinationAuthorizationEntry));
        }
    }

    @Override
    public void store() {
        this.factory.store();
    }

    private synchronized void restore() {
        this.store();
        this.reload();
    }

    @Override
    public synchronized void addUserRoles(String user, String roles) {
        if (this.factory.getAuthenticationUser(user) != null && roles != null) {
            StringTokenizer tokenizer = new StringTokenizer(roles, ",");
            while (tokenizer.hasMoreTokens()) {
                String role = tokenizer.nextToken();
                this.factory.getAuthenticationUser(user).getGroups().add((Principal)new GroupPrincipal(role));
            }
        }
        this.restore();
    }

    @Override
    public synchronized void removeUserRoles(String user, String roles) {
        if (this.factory.getAuthenticationUser(user) != null) {
            this.factory.getAuthenticationUser(user).getGroups().remove(new GroupPrincipal(roles));
        }
        this.restore();
    }

    @Override
    public synchronized void addTopicRoles(String topic, String operations, String roles) {
        String topicKey = topic;
        if (topic != null) {
            topicKey = TOPIC_PREFIX + topic;
        }
        PMQAuthorizationEntry authorizationEntry = this.checkRole(topicKey, operations, roles);
        PMQTopicAuthorizationEntry topicAuthorizationEntry = null;
        Map<String, PMQAuthorizationEntry> authorizations = this.factory.getAuthcAuthzEntry().getAuthorizations();
        if (authorizationEntry == null) {
            topicAuthorizationEntry = new PMQTopicAuthorizationEntry();
            topicAuthorizationEntry.setTopic(topic);
            authorizations.put(topicKey, topicAuthorizationEntry);
        } else {
            topicAuthorizationEntry = (PMQTopicAuthorizationEntry)authorizationEntry;
        }
        StringTokenizer tokenizer = new StringTokenizer(operations, ",");
        while (tokenizer.hasMoreTokens()) {
            String operation = tokenizer.nextToken();
            this.addRole(operation, roles, topicAuthorizationEntry);
        }
        this.restore();
    }

    @Override
    public synchronized void removeTopicRoles(String topic, String operations, String roles) {
        PMQAuthorizationEntry authorizationEntry;
        String topicKey = topic;
        if (topic != null) {
            topicKey = TOPIC_PREFIX + topic;
        }
        if ((authorizationEntry = this.checkRole(topicKey, operations, roles)) == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(operations, ",");
        while (tokenizer.hasMoreTokens()) {
            String operation = tokenizer.nextToken();
            this.removeRoles(operation, roles, authorizationEntry);
        }
        this.restore();
    }

    @Override
    public synchronized void addQueueRoles(String queue2, String operations, String roles) {
        String queueKey = queue2;
        if (queue2 != null) {
            queueKey = QUEUE_PREFIX + queue2;
        }
        PMQQueueAuthorizationEntry queueAuthorizationEntry = null;
        Map<String, PMQAuthorizationEntry> authorizations = this.factory.getAuthcAuthzEntry().getAuthorizations();
        PMQAuthorizationEntry authorizationEntry = this.checkRole(queueKey, operations, roles);
        if (authorizationEntry == null) {
            queueAuthorizationEntry = new PMQQueueAuthorizationEntry();
            queueAuthorizationEntry.setQueue(queue2);
            authorizations.put(queueKey, queueAuthorizationEntry);
        } else {
            queueAuthorizationEntry = (PMQQueueAuthorizationEntry)authorizationEntry;
        }
        StringTokenizer tokenizer = new StringTokenizer(operations, ",");
        while (tokenizer.hasMoreTokens()) {
            String operation = tokenizer.nextToken();
            this.addRole(operation, roles, queueAuthorizationEntry);
        }
        this.restore();
    }

    @Override
    public synchronized void removeQueueRoles(String queue2, String operations, String roles) {
        PMQAuthorizationEntry authorizationEntry;
        String queueKey = queue2;
        if (queue2 != null) {
            queueKey = QUEUE_PREFIX + queue2;
        }
        if ((authorizationEntry = this.checkRole(queueKey, operations, roles)) == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(operations, ",");
        while (tokenizer.hasMoreTokens()) {
            String operation = tokenizer.nextToken();
            this.removeRoles(operation, roles, authorizationEntry);
        }
        this.restore();
    }

    @Override
    public void deleteAuthorization(String name, String type) {
        if ("queue".equals(type)) {
            this.factory.deleteAuthorization(QUEUE_PREFIX + name);
        } else {
            this.factory.deleteAuthorization(TOPIC_PREFIX + name);
        }
    }

    @Override
    public List<PMQAuthorizationEntry> getAuthorizations() {
        return new ArrayList<PMQAuthorizationEntry>(this.factory.getAuthcAuthzEntry().getAuthorizations().values());
    }

    private PMQAuthorizationEntry checkRole(String dest, String operation, String roles) {
        Objects.requireNonNull(dest);
        Objects.requireNonNull(operation);
        Objects.requireNonNull(roles);
        Map<String, PMQAuthorizationEntry> authorizations = this.factory.getAuthcAuthzEntry().getAuthorizations();
        return authorizations.get(dest);
    }

    private void addRole(String operation, String roles, PMQAuthorizationEntry authorizationEntry) {
        this.applyRoles(roles, role -> {
            switch (operation) {
                case "admin": {
                    authorizationEntry.getAdminRoles().add((Principal)new GroupPrincipal(role));
                    break;
                }
                case "read": {
                    authorizationEntry.getReadRoles().add((Principal)new GroupPrincipal(role));
                    break;
                }
                case "write": {
                    authorizationEntry.getWriteRoles().add((Principal)new GroupPrincipal(role));
                }
            }
        });
    }

    private void removeRoles(String operation, String roles, PMQAuthorizationEntry authorizationEntry) {
        this.applyRoles(roles, role -> {
            switch (operation) {
                case "admin": {
                    if ("*".equals(roles)) {
                        authorizationEntry.getAdminRoles().clear();
                        break;
                    }
                    authorizationEntry.getAdminRoles().remove(new GroupPrincipal(role));
                    break;
                }
                case "read": {
                    if ("*".equals(roles)) {
                        authorizationEntry.getReadRoles().clear();
                        break;
                    }
                    authorizationEntry.getReadRoles().remove(new GroupPrincipal(role));
                    break;
                }
                case "write": {
                    if ("*".equals(roles)) {
                        authorizationEntry.getWriteRoles().clear();
                        break;
                    }
                    authorizationEntry.getWriteRoles().remove(new GroupPrincipal(role));
                }
            }
        });
    }

    private void applyRoles(String roles, Consumer<String> consumer) {
        if (roles == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(roles, ",");
        while (tokenizer.hasMoreTokens()) {
            String role = tokenizer.nextToken();
            consumer.accept(role);
        }
    }
}

