/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.security.pmq.dto;

import com.primeton.pmq.jaas.GroupPrincipal;
import com.primeton.pmq.security.pmq.dto.GroupRolesAdapter;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="user")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PMQAuthenticationUser {
    @XmlAttribute
    private String username;
    @XmlAttribute
    private String password;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=GroupRolesAdapter.class)
    private Set<Principal> groups = new HashSet<Principal>();

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<Principal> getGroups() {
        return this.groups;
    }

    public void addGroup(String group) {
        this.groups.add((Principal)new GroupPrincipal(group));
    }

    public void removeGroup(String group) {
        this.groups.remove(new GroupPrincipal(group));
    }

    public String getGroupsValue() {
        return this.groups.stream().map(Principal::getName).collect(Collectors.joining(","));
    }
}

