/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store;

import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.SubscriptionInfo;
import com.primeton.pmq.store.PersistenceAdapter;
import com.primeton.pmq.store.TopicMessageStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PersistenceAdapterSupport {
    private static final DestinationMatcher MATCH_ALL = new AlwaysMatches();

    public static List<SubscriptionInfo> listSubscriptions(PersistenceAdapter adapter, String clientId) throws IOException {
        ArrayList<SubscriptionInfo> rc = new ArrayList<SubscriptionInfo>();
        for (PMQDestination destination : adapter.getDestinations()) {
            if (!destination.isTopic()) continue;
            TopicMessageStore store2 = adapter.createTopicMessageStore((PMQTopic)destination);
            for (SubscriptionInfo sub : store2.getAllSubscriptions()) {
                if (clientId != sub.getClientId() && !clientId.equals(sub.getClientId())) continue;
                rc.add(sub);
            }
        }
        return rc;
    }

    public static List<PMQQueue> listQueues(PersistenceAdapter adapter) throws IOException {
        return PersistenceAdapterSupport.listQueues(adapter, MATCH_ALL);
    }

    public static List<PMQQueue> listQueues(PersistenceAdapter adapter, DestinationMatcher matcher) throws IOException {
        ArrayList<PMQQueue> rc = new ArrayList<PMQQueue>();
        for (PMQDestination destination : adapter.getDestinations()) {
            if (!destination.isQueue() || !matcher.matches(destination)) continue;
            rc.add((PMQQueue)destination);
        }
        return rc;
    }

    public static List<PMQTopic> listTopics(PersistenceAdapter adapter) throws IOException {
        return PersistenceAdapterSupport.listTopics(adapter, MATCH_ALL);
    }

    public static List<PMQTopic> listTopics(PersistenceAdapter adapter, DestinationMatcher matcher) throws IOException {
        ArrayList<PMQTopic> rc = new ArrayList<PMQTopic>();
        for (PMQDestination destination : adapter.getDestinations()) {
            if (!destination.isTopic() || !matcher.matches(destination)) continue;
            rc.add((PMQTopic)destination);
        }
        return rc;
    }

    private static class AlwaysMatches
    implements DestinationMatcher {
        private AlwaysMatches() {
        }

        @Override
        public boolean matches(PMQDestination destination) {
            return true;
        }
    }

    public static interface DestinationMatcher {
        public boolean matches(PMQDestination var1);
    }
}

