/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.journal;

import com.primeton.pmq.command.JournalTopicAck;
import com.primeton.pmq.command.JournalTransaction;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.MessageAck;
import com.primeton.pmq.command.TransactionId;
import com.primeton.pmq.command.XATransactionId;
import com.primeton.pmq.store.TransactionRecoveryListener;
import com.primeton.pmq.store.TransactionStore;
import com.primeton.pmq.store.journal.JournalMessageStore;
import com.primeton.pmq.store.journal.JournalPersistenceAdapter;
import com.primeton.pmq.store.journal.JournalTopicMessageStore;
import com.primeton.pmqio.journal.RecordLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class JournalTransactionStore
implements TransactionStore {
    private final JournalPersistenceAdapter peristenceAdapter;
    private final Map<Object, Tx> inflightTransactions = new LinkedHashMap<Object, Tx>();
    private final Map<TransactionId, Tx> preparedTransactions = new LinkedHashMap<TransactionId, Tx>();
    private boolean doingRecover;

    public JournalTransactionStore(JournalPersistenceAdapter adapter) {
        this.peristenceAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(TransactionId txid) throws IOException {
        Tx tx = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx == null) {
            return;
        }
        this.peristenceAdapter.writeCommand(new JournalTransaction(1, txid, false), true);
        map = this.preparedTransactions;
        synchronized (map) {
            this.preparedTransactions.put(txid, tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayPrepare(TransactionId txid) throws IOException {
        Tx tx = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx == null) {
            return;
        }
        map = this.preparedTransactions;
        synchronized (map) {
            this.preparedTransactions.put(txid, tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tx getTx(Object txid, RecordLocation location) {
        Tx tx = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.get(txid);
        }
        if (tx == null) {
            tx = new Tx(location);
            this.inflightTransactions.put(txid, tx);
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(TransactionId txid, boolean wasPrepared, Runnable preCommit, Runnable postCommit) throws IOException {
        Tx tx;
        if (preCommit != null) {
            preCommit.run();
        }
        if (wasPrepared) {
            Map<TransactionId, Tx> map = this.preparedTransactions;
            synchronized (map) {
                tx = this.preparedTransactions.remove(txid);
            }
        }
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx == null) {
            if (postCommit != null) {
                postCommit.run();
            }
            return;
        }
        if (txid.isXATransaction()) {
            this.peristenceAdapter.writeCommand(new JournalTransaction(2, txid, wasPrepared), true);
        } else {
            this.peristenceAdapter.writeCommand(new JournalTransaction(4, txid, wasPrepared), true);
        }
        if (postCommit != null) {
            postCommit.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tx replayCommit(TransactionId txid, boolean wasPrepared) throws IOException {
        if (wasPrepared) {
            Map<TransactionId, Tx> map = this.preparedTransactions;
            synchronized (map) {
                return this.preparedTransactions.remove(txid);
            }
        }
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            return this.inflightTransactions.remove(txid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(TransactionId txid) throws IOException {
        Tx tx = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx != null) {
            map = this.preparedTransactions;
            synchronized (map) {
                tx = this.preparedTransactions.remove(txid);
            }
        }
        if (tx != null) {
            if (txid.isXATransaction()) {
                this.peristenceAdapter.writeCommand(new JournalTransaction(3, txid, false), true);
            } else {
                this.peristenceAdapter.writeCommand(new JournalTransaction(5, txid, false), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayRollback(TransactionId txid) throws IOException {
        boolean inflight = false;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            inflight = this.inflightTransactions.remove(txid) != null;
        }
        if (inflight) {
            map = this.preparedTransactions;
            synchronized (map) {
                this.preparedTransactions.remove(txid);
            }
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void recover(TransactionRecoveryListener listener) throws IOException {
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            this.inflightTransactions.clear();
        }
        this.doingRecover = true;
        try {
            LinkedHashMap<TransactionId, Tx> txs = null;
            Map<TransactionId, Tx> map2 = this.preparedTransactions;
            synchronized (map2) {
                txs = new LinkedHashMap<TransactionId, Tx>(this.preparedTransactions);
            }
            for (Object txid : txs.keySet()) {
                Tx tx = (Tx)txs.get(txid);
                listener.recover((XATransactionId)txid, tx.getMessages(), tx.getAcks());
            }
        }
        finally {
            this.doingRecover = false;
        }
    }

    void addMessage(JournalMessageStore store2, Message message, RecordLocation location) throws IOException {
        Tx tx = this.getTx(message.getTransactionId(), location);
        tx.add(store2, message);
    }

    public void removeMessage(JournalMessageStore store2, MessageAck ack, RecordLocation location) throws IOException {
        Tx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store2, ack);
    }

    public void acknowledge(JournalTopicMessageStore store2, JournalTopicAck ack, RecordLocation location) {
        Tx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store2, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint() throws IOException {
        RecordLocation location;
        RecordLocation rc = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            for (Tx tx : this.inflightTransactions.values()) {
                location = tx.location;
                if (rc != null && rc.compareTo((Object)location) >= 0) continue;
                rc = location;
            }
        }
        map = this.preparedTransactions;
        synchronized (map) {
            for (Tx tx : this.preparedTransactions.values()) {
                location = tx.location;
                if (rc != null && rc.compareTo((Object)location) >= 0) continue;
                rc = location;
            }
            return rc;
        }
    }

    public boolean isDoingRecover() {
        return this.doingRecover;
    }

    public static class Tx {
        private final RecordLocation location;
        private final ArrayList<TxOperation> operations = new ArrayList();

        public Tx(RecordLocation location) {
            this.location = location;
        }

        public void add(JournalMessageStore store2, Message msg) {
            this.operations.add(new TxOperation(0, store2, msg));
        }

        public void add(JournalMessageStore store2, MessageAck ack) {
            this.operations.add(new TxOperation(1, store2, ack));
        }

        public void add(JournalTopicMessageStore store2, JournalTopicAck ack) {
            this.operations.add(new TxOperation(3, store2, ack));
        }

        public Message[] getMessages() {
            ArrayList<Object> list = new ArrayList<Object>();
            for (TxOperation op : this.operations) {
                if (op.operationType != 0) continue;
                list.add(op.data);
            }
            Message[] rc = new Message[list.size()];
            list.toArray(rc);
            return rc;
        }

        public MessageAck[] getAcks() {
            ArrayList<Object> list = new ArrayList<Object>();
            for (TxOperation op : this.operations) {
                if (op.operationType != 1) continue;
                list.add(op.data);
            }
            MessageAck[] rc = new MessageAck[list.size()];
            list.toArray(rc);
            return rc;
        }

        public ArrayList<TxOperation> getOperations() {
            return this.operations;
        }
    }

    public static class TxOperation {
        static final byte ADD_OPERATION_TYPE = 0;
        static final byte REMOVE_OPERATION_TYPE = 1;
        static final byte ACK_OPERATION_TYPE = 3;
        public byte operationType;
        public JournalMessageStore store;
        public Object data;

        public TxOperation(byte operationType, JournalMessageStore store2, Object data) {
            this.operationType = operationType;
            this.store = store2;
            this.data = data;
        }
    }
}

