/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.kahadb;

import com.primeton.pmq.broker.LockableServiceSupport;
import com.primeton.pmq.broker.Locker;
import com.primeton.pmq.store.SharedFileLocker;
import com.primeton.pmq.store.kahadb.JournalCommand;
import com.primeton.pmq.store.kahadb.data.KahaEntryType;
import com.primeton.pmq.store.kahadb.data.KahaTraceCommand;
import com.primeton.pmq.store.kahadb.disk.journal.Journal;
import com.primeton.pmq.store.kahadb.disk.journal.Location;
import com.primeton.pmq.store.kahadb.disk.page.PageFile;
import com.primeton.pmq.store.kahadb.disk.page.Transaction;
import com.primeton.pmq.util.ByteSequence;
import com.primeton.pmq.util.DataByteArrayInputStream;
import com.primeton.pmq.util.DataByteArrayOutputStream;
import com.primeton.pmq.util.IOHelper;
import com.primeton.pmq.util.ServiceStopper;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKahaDBStore
extends LockableServiceSupport {
    static final Logger LOG = LoggerFactory.getLogger(AbstractKahaDBStore.class);
    public static final String PROPERTY_LOG_SLOW_ACCESS_TIME = "com.primeton.pmq.store.kahadb.LOG_SLOW_ACCESS_TIME";
    public static final int LOG_SLOW_ACCESS_TIME = Integer.getInteger("com.primeton.pmq.store.kahadb.LOG_SLOW_ACCESS_TIME", 0);
    protected File directory;
    protected PageFile pageFile;
    protected Journal journal;
    protected AtomicLong journalSize = new AtomicLong(0L);
    protected boolean failIfDatabaseIsLocked;
    protected long checkpointInterval = 5000L;
    protected long cleanupInterval = 30000L;
    protected boolean checkForCorruptJournalFiles = false;
    protected boolean checksumJournalFiles = true;
    protected boolean forceRecoverIndex = false;
    protected int journalMaxFileLength = 0x2000000;
    protected int journalMaxWriteBatchSize = 0x400000;
    protected boolean archiveCorruptedIndex = false;
    protected boolean enableIndexWriteAsync = false;
    protected boolean enableJournalDiskSyncs = false;
    protected boolean deleteAllJobs = false;
    protected int indexWriteBatchSize = PageFile.DEFAULT_WRITE_BATCH_SIZE;
    protected boolean useIndexLFRUEviction = false;
    protected float indexLFUEvictionFactor = 0.2f;
    protected boolean ignoreMissingJournalfiles = false;
    protected int indexCacheSize = 1000;
    protected boolean enableIndexDiskSyncs = true;
    protected boolean enableIndexRecoveryFile = true;
    protected boolean enableIndexPageCaching = true;
    protected boolean archiveDataLogs;
    protected boolean purgeStoreOnStartup;
    protected File directoryArchive;
    protected AtomicBoolean opened = new AtomicBoolean();
    protected Thread checkpointThread;
    protected final Object checkpointThreadLock = new Object();
    protected ReentrantReadWriteLock checkpointLock = new ReentrantReadWriteLock();
    protected ReentrantReadWriteLock indexLock = new ReentrantReadWriteLock();

    protected abstract String getPageFileName();

    protected abstract File getDefaultDataDirectory();

    public abstract void load() throws IOException;

    public abstract void unload() throws IOException;

    @Override
    protected void doStart() throws Exception {
        this.indexLock.writeLock().lock();
        if (this.getDirectory() == null) {
            this.setDirectory(this.getDefaultDataDirectory());
        }
        IOHelper.mkdirs(this.getDirectory());
        try {
            if (this.isPurgeStoreOnStartup()) {
                this.getJournal().start();
                this.getJournal().delete();
                this.getJournal().close();
                this.journal = null;
                this.getPageFile().delete();
                LOG.info("{} Persistence store purged.", (Object)this);
                this.setPurgeStoreOnStartup(false);
            }
            this.load();
            this.store((JournalCommand)new KahaTraceCommand().setMessage("LOADED " + new Date()));
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        this.unload();
    }

    public PageFile getPageFile() {
        if (this.pageFile == null) {
            this.pageFile = this.createPageFile();
        }
        return this.pageFile;
    }

    public Journal getJournal() throws IOException {
        if (this.journal == null) {
            this.journal = this.createJournal();
        }
        return this.journal;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public boolean isArchiveCorruptedIndex() {
        return this.archiveCorruptedIndex;
    }

    public void setArchiveCorruptedIndex(boolean archiveCorruptedIndex) {
        this.archiveCorruptedIndex = archiveCorruptedIndex;
    }

    public boolean isFailIfDatabaseIsLocked() {
        return this.failIfDatabaseIsLocked;
    }

    public void setFailIfDatabaseIsLocked(boolean failIfDatabaseIsLocked) {
        this.failIfDatabaseIsLocked = failIfDatabaseIsLocked;
    }

    public boolean isCheckForCorruptJournalFiles() {
        return this.checkForCorruptJournalFiles;
    }

    public void setCheckForCorruptJournalFiles(boolean checkForCorruptJournalFiles) {
        this.checkForCorruptJournalFiles = checkForCorruptJournalFiles;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public boolean isChecksumJournalFiles() {
        return this.checksumJournalFiles;
    }

    public void setChecksumJournalFiles(boolean checksumJournalFiles) {
        this.checksumJournalFiles = checksumJournalFiles;
    }

    public boolean isForceRecoverIndex() {
        return this.forceRecoverIndex;
    }

    public void setForceRecoverIndex(boolean forceRecoverIndex) {
        this.forceRecoverIndex = forceRecoverIndex;
    }

    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalMaxWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.journalMaxWriteBatchSize = journalMaxWriteBatchSize;
    }

    public boolean isEnableIndexWriteAsync() {
        return this.enableIndexWriteAsync;
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.enableIndexWriteAsync = enableIndexWriteAsync;
    }

    public boolean isEnableJournalDiskSyncs() {
        return this.enableJournalDiskSyncs;
    }

    public void setEnableJournalDiskSyncs(boolean syncWrites) {
        this.enableJournalDiskSyncs = syncWrites;
    }

    public boolean isDeleteAllJobs() {
        return this.deleteAllJobs;
    }

    public void setDeleteAllJobs(boolean deleteAllJobs) {
        this.deleteAllJobs = deleteAllJobs;
    }

    public boolean isArchiveDataLogs() {
        return this.archiveDataLogs;
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.archiveDataLogs = archiveDataLogs;
    }

    public File getDirectoryArchive() {
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchive = directoryArchive;
    }

    public int getIndexCacheSize() {
        return this.indexCacheSize;
    }

    public void setIndexCacheSize(int indexCacheSize) {
        this.indexCacheSize = indexCacheSize;
    }

    public int getIndexWriteBatchSize() {
        return this.indexWriteBatchSize;
    }

    public void setIndexWriteBatchSize(int indexWriteBatchSize) {
        this.indexWriteBatchSize = indexWriteBatchSize;
    }

    public boolean isUseIndexLFRUEviction() {
        return this.useIndexLFRUEviction;
    }

    public void setUseIndexLFRUEviction(boolean useIndexLFRUEviction) {
        this.useIndexLFRUEviction = useIndexLFRUEviction;
    }

    public float getIndexLFUEvictionFactor() {
        return this.indexLFUEvictionFactor;
    }

    public void setIndexLFUEvictionFactor(float indexLFUEvictionFactor) {
        this.indexLFUEvictionFactor = indexLFUEvictionFactor;
    }

    public boolean isEnableIndexDiskSyncs() {
        return this.enableIndexDiskSyncs;
    }

    public void setEnableIndexDiskSyncs(boolean enableIndexDiskSyncs) {
        this.enableIndexDiskSyncs = enableIndexDiskSyncs;
    }

    public boolean isEnableIndexRecoveryFile() {
        return this.enableIndexRecoveryFile;
    }

    public void setEnableIndexRecoveryFile(boolean enableIndexRecoveryFile) {
        this.enableIndexRecoveryFile = enableIndexRecoveryFile;
    }

    public boolean isEnableIndexPageCaching() {
        return this.enableIndexPageCaching;
    }

    public void setEnableIndexPageCaching(boolean enableIndexPageCaching) {
        this.enableIndexPageCaching = enableIndexPageCaching;
    }

    public boolean isPurgeStoreOnStartup() {
        return this.purgeStoreOnStartup;
    }

    public void setPurgeStoreOnStartup(boolean purge2) {
        this.purgeStoreOnStartup = purge2;
    }

    public boolean isIgnoreMissingJournalfiles() {
        return this.ignoreMissingJournalfiles;
    }

    public void setIgnoreMissingJournalfiles(boolean ignoreMissingJournalfiles) {
        this.ignoreMissingJournalfiles = ignoreMissingJournalfiles;
    }

    public long size() {
        if (!this.isStarted()) {
            return 0L;
        }
        try {
            return this.journalSize.get() + this.pageFile.getDiskSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Locker createDefaultLocker() throws IOException {
        SharedFileLocker locker = new SharedFileLocker();
        locker.setDirectory(this.getDirectory());
        return locker;
    }

    @Override
    public void init() throws Exception {
    }

    public Location store(JournalCommand<?> command) throws IOException {
        return this.store(command, this.isEnableIndexDiskSyncs(), null, null, null);
    }

    public Location store(JournalCommand<?> command, boolean sync) throws IOException {
        return this.store(command, sync, null, null, null);
    }

    public Location store(JournalCommand<?> command, Runnable onJournalStoreComplete) throws IOException {
        return this.store(command, this.isEnableIndexDiskSyncs(), null, null, onJournalStoreComplete);
    }

    public Location store(JournalCommand<?> command, boolean sync, Runnable before, Runnable after) throws IOException {
        return this.store(command, sync, before, after, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location store(JournalCommand<?> command, boolean sync, Runnable before, Runnable after, Runnable onJournalStoreComplete) throws IOException {
        try {
            Location location;
            if (before != null) {
                before.run();
            }
            ByteSequence sequence = this.toByteSequence(command);
            this.checkpointLock.readLock().lock();
            try {
                long start2 = System.currentTimeMillis();
                location = onJournalStoreComplete == null ? this.journal.write(sequence, sync) : this.journal.write(sequence, onJournalStoreComplete);
                long start22 = System.currentTimeMillis();
                this.process(command, location);
                long end = System.currentTimeMillis();
                if (LOG_SLOW_ACCESS_TIME > 0 && end - start2 > (long)LOG_SLOW_ACCESS_TIME) {
                    LOG.info("Slow KahaDB access: Journal append took: {} ms, Index update took {} ms", (Object)(start22 - start2), (Object)(end - start22));
                }
            }
            finally {
                this.checkpointLock.readLock().unlock();
            }
            if (after != null) {
                after.run();
            }
            if (this.checkpointThread != null && !this.checkpointThread.isAlive()) {
                this.startCheckpoint();
            }
            return location;
        }
        catch (IOException ioe) {
            LOG.error("KahaDB failed to store to Journal", ioe);
            if (this.brokerService != null) {
                this.brokerService.handleIOException(ioe);
            }
            throw ioe;
        }
    }

    protected JournalCommand<?> load(Location location) throws IOException {
        ByteSequence data = this.journal.read(location);
        DataByteArrayInputStream is = new DataByteArrayInputStream(data);
        byte readByte = is.readByte();
        KahaEntryType type = KahaEntryType.valueOf(readByte);
        if (type == null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException("Could not load journal record. Invalid location: " + location);
        }
        JournalCommand message = (JournalCommand)type.createMessage();
        message.mergeFramed(is);
        return message;
    }

    protected abstract void process(JournalCommand<?> var1, Location var2) throws IOException;

    protected void checkpointUpdate(final boolean cleanup) throws IOException {
        this.checkpointLock.writeLock().lock();
        try {
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        AbstractKahaDBStore.this.checkpointUpdate(tx, cleanup);
                    }
                });
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
    }

    protected abstract void checkpointUpdate(Transaction var1, boolean var2) throws IOException;

    protected ByteSequence toByteSequence(JournalCommand<?> data) throws IOException {
        int size2 = data.serializedSizeFramed();
        DataByteArrayOutputStream os = new DataByteArrayOutputStream(size2 + 1);
        os.writeByte(data.type().getNumber());
        data.writeFramed(os);
        return os.toByteSequence();
    }

    protected PageFile createPageFile() {
        PageFile index = new PageFile(this.getDirectory(), this.getPageFileName());
        index.setEnableWriteThread(this.isEnableIndexWriteAsync());
        index.setWriteBatchSize(this.getIndexWriteBatchSize());
        index.setPageCacheSize(this.getIndexCacheSize());
        index.setUseLFRUEviction(this.isUseIndexLFRUEviction());
        index.setLFUEvictionFactor(this.getIndexLFUEvictionFactor());
        index.setEnableDiskSyncs(this.isEnableIndexDiskSyncs());
        index.setEnableRecoveryFile(this.isEnableIndexRecoveryFile());
        index.setEnablePageCaching(this.isEnableIndexPageCaching());
        return index;
    }

    protected Journal createJournal() throws IOException {
        Journal manager = new Journal();
        manager.setDirectory(this.getDirectory());
        manager.setMaxFileLength(this.getJournalMaxFileLength());
        manager.setCheckForCorruptionOnStartup(this.isCheckForCorruptJournalFiles());
        manager.setChecksum(this.isChecksumJournalFiles() || this.isCheckForCorruptJournalFiles());
        manager.setWriteBatchSize(this.getJournalMaxWriteBatchSize());
        manager.setArchiveDataLogs(this.isArchiveDataLogs());
        manager.setSizeAccumulator(this.journalSize);
        manager.setEnableAsyncDiskSync(this.isEnableJournalDiskSyncs());
        if (this.getDirectoryArchive() != null) {
            IOHelper.mkdirs(this.getDirectoryArchive());
            manager.setDirectoryArchive(this.getDirectoryArchive());
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startCheckpoint() {
        if (this.checkpointInterval == 0L && this.cleanupInterval == 0L) {
            LOG.info("periodic checkpoint/cleanup disabled, will ocurr on clean shutdown/restart");
            return;
        }
        Object object = this.checkpointThreadLock;
        synchronized (object) {
            boolean start2 = false;
            if (this.checkpointThread == null) {
                start2 = true;
            } else if (!this.checkpointThread.isAlive()) {
                start2 = true;
                LOG.info("KahaDB: Recovering checkpoint thread after death");
            }
            if (start2) {
                this.checkpointThread = new Thread("PMQ Journal Checkpoint Worker"){

                    @Override
                    public void run() {
                        try {
                            long lastCleanup = System.currentTimeMillis();
                            long lastCheckpoint = System.currentTimeMillis();
                            long sleepTime = Math.min(AbstractKahaDBStore.this.checkpointInterval > 0L ? AbstractKahaDBStore.this.checkpointInterval : AbstractKahaDBStore.this.cleanupInterval, 500L);
                            while (AbstractKahaDBStore.this.opened.get()) {
                                Thread.sleep(sleepTime);
                                long now = System.currentTimeMillis();
                                if (AbstractKahaDBStore.this.cleanupInterval > 0L && now - lastCleanup >= AbstractKahaDBStore.this.cleanupInterval) {
                                    AbstractKahaDBStore.this.checkpointCleanup(true);
                                    lastCleanup = now;
                                    lastCheckpoint = now;
                                    continue;
                                }
                                if (AbstractKahaDBStore.this.checkpointInterval <= 0L || now - lastCheckpoint < AbstractKahaDBStore.this.checkpointInterval) continue;
                                AbstractKahaDBStore.this.checkpointCleanup(false);
                                lastCheckpoint = now;
                            }
                        }
                        catch (InterruptedException lastCleanup) {
                        }
                        catch (IOException ioe) {
                            LOG.error("Checkpoint failed", ioe);
                            AbstractKahaDBStore.this.brokerService.handleIOException(ioe);
                        }
                    }
                };
                this.checkpointThread.setDaemon(true);
                this.checkpointThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkpointCleanup(boolean cleanup) throws IOException {
        long start2;
        this.indexLock.writeLock().lock();
        try {
            start2 = System.currentTimeMillis();
            if (!this.opened.get()) {
                return;
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
        this.checkpointUpdate(cleanup);
        long end = System.currentTimeMillis();
        if (LOG_SLOW_ACCESS_TIME > 0 && end - start2 > (long)LOG_SLOW_ACCESS_TIME) {
            LOG.info("Slow KahaDB access: cleanup took {}", (Object)(end - start2));
        }
    }
}

