/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.kahadb;

import com.primeton.pmq.command.ConnectionId;
import com.primeton.pmq.command.LocalTransactionId;
import com.primeton.pmq.command.TransactionId;
import com.primeton.pmq.command.XATransactionId;
import com.primeton.pmq.protobuf.Buffer;
import com.primeton.pmq.store.kahadb.data.KahaLocalTransactionId;
import com.primeton.pmq.store.kahadb.data.KahaTransactionInfo;
import com.primeton.pmq.store.kahadb.data.KahaXATransactionId;

public class TransactionIdConversion {
    static KahaTransactionInfo convertToLocal(TransactionId tx) {
        KahaTransactionInfo rc = new KahaTransactionInfo();
        LocalTransactionId t = (LocalTransactionId)tx;
        KahaLocalTransactionId kahaTxId = new KahaLocalTransactionId();
        kahaTxId.setConnectionId(t.getConnectionId().getValue());
        kahaTxId.setTransactionId(t.getValue());
        rc.setLocalTransactionId(kahaTxId);
        return rc;
    }

    static KahaTransactionInfo convert(TransactionId txid) {
        KahaTransactionInfo rc;
        if (txid == null) {
            return null;
        }
        if (txid.isLocalTransaction()) {
            rc = TransactionIdConversion.convertToLocal(txid);
        } else {
            rc = new KahaTransactionInfo();
            XATransactionId t = (XATransactionId)txid;
            KahaXATransactionId kahaTxId = new KahaXATransactionId();
            kahaTxId.setBranchQualifier(new Buffer(t.getBranchQualifier()));
            kahaTxId.setGlobalTransactionId(new Buffer(t.getGlobalTransactionId()));
            kahaTxId.setFormatId(t.getFormatId());
            rc.setXaTransactionId(kahaTxId);
        }
        return rc;
    }

    static TransactionId convert(KahaTransactionInfo transactionInfo) {
        if (transactionInfo.hasLocalTransactionId()) {
            KahaLocalTransactionId tx = transactionInfo.getLocalTransactionId();
            LocalTransactionId rc = new LocalTransactionId();
            rc.setConnectionId(new ConnectionId(tx.getConnectionId()));
            rc.setValue(tx.getTransactionId());
            return rc;
        }
        KahaXATransactionId tx = transactionInfo.getXaTransactionId();
        XATransactionId rc = new XATransactionId();
        rc.setBranchQualifier(tx.getBranchQualifier().toByteArray());
        rc.setGlobalTransactionId(tx.getGlobalTransactionId().toByteArray());
        rc.setFormatId(tx.getFormatId());
        return rc;
    }
}

