/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.kahadb.disk.index;

import java.util.List;

public interface BTreeVisitor<Key, Value> {
    public boolean isInterestedInKeysBetween(Key var1, Key var2);

    public void visit(List<Key> var1, List<Value> var2);

    public static class LTEVisitor<Key extends Comparable<Key>, Value>
    extends PredicateVisitor<Key, Value> {
        private final Key value;

        public LTEVisitor(Key value) {
            this.value = value;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            return first == null || first.compareTo(this.value) <= 0;
        }

        @Override
        public boolean isInterestedInKey(Key key) {
            return key.compareTo(this.value) <= 0;
        }

        public String toString() {
            return "key <= " + this.value;
        }
    }

    public static class LTVisitor<Key extends Comparable<Key>, Value>
    extends PredicateVisitor<Key, Value> {
        private final Key value;

        public LTVisitor(Key value) {
            this.value = value;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            return first == null || first.compareTo(this.value) < 0;
        }

        @Override
        public boolean isInterestedInKey(Key key) {
            return key.compareTo(this.value) < 0;
        }

        public String toString() {
            return "key < " + this.value;
        }
    }

    public static class GTEVisitor<Key extends Comparable<Key>, Value>
    extends PredicateVisitor<Key, Value> {
        private final Key value;

        public GTEVisitor(Key value) {
            this.value = value;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            return second == null || second.compareTo(this.value) >= 0;
        }

        @Override
        public boolean isInterestedInKey(Key key) {
            return key.compareTo(this.value) >= 0;
        }

        public String toString() {
            return "key >= " + this.value;
        }
    }

    public static class GTVisitor<Key extends Comparable<Key>, Value>
    extends PredicateVisitor<Key, Value> {
        private final Key value;

        public GTVisitor(Key value) {
            this.value = value;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            return second == null || second.compareTo(this.value) > 0;
        }

        @Override
        public boolean isInterestedInKey(Key key) {
            return key.compareTo(this.value) > 0;
        }

        public String toString() {
            return "key > " + this.value;
        }
    }

    public static class BetweenVisitor<Key extends Comparable<Key>, Value>
    extends PredicateVisitor<Key, Value> {
        private final Key first;
        private final Key last;

        public BetweenVisitor(Key first, Key last) {
            this.first = first;
            this.last = last;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            return !(second != null && second.compareTo(this.first) < 0 || first != null && first.compareTo(this.last) >= 0);
        }

        @Override
        public boolean isInterestedInKey(Key key) {
            return key.compareTo(this.first) >= 0 && key.compareTo(this.last) < 0;
        }

        public String toString() {
            return this.first + " >= key < " + this.last;
        }
    }

    public static class AndVisitor<Key, Value>
    extends PredicateVisitor<Key, Value> {
        private final List<Predicate<Key>> conditions;

        public AndVisitor(List<Predicate<Key>> conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            for (Predicate<Key> condition : this.conditions) {
                if (condition.isInterestedInKeysBetween(first, second)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isInterestedInKey(Key key) {
            for (Predicate<Key> condition : this.conditions) {
                if (condition.isInterestedInKey(key)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Predicate<Key> condition : this.conditions) {
                if (!first) {
                    sb.append(" AND ");
                }
                first = false;
                sb.append("(");
                sb.append(condition);
                sb.append(")");
            }
            return sb.toString();
        }
    }

    public static class OrVisitor<Key, Value>
    extends PredicateVisitor<Key, Value> {
        private final List<Predicate<Key>> conditions;

        public OrVisitor(List<Predicate<Key>> conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            for (Predicate<Key> condition : this.conditions) {
                if (!condition.isInterestedInKeysBetween(first, second)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isInterestedInKey(Key key) {
            for (Predicate<Key> condition : this.conditions) {
                if (!condition.isInterestedInKey(key)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Predicate<Key> condition : this.conditions) {
                if (!first) {
                    sb.append(" OR ");
                }
                first = false;
                sb.append("(");
                sb.append(condition);
                sb.append(")");
            }
            return sb.toString();
        }
    }

    public static abstract class PredicateVisitor<Key, Value>
    implements BTreeVisitor<Key, Value>,
    Predicate<Key> {
        @Override
        public void visit(List<Key> keys, List<Value> values) {
            for (int i = 0; i < keys.size(); ++i) {
                Key key = keys.get(i);
                if (!this.isInterestedInKey(key)) continue;
                this.matched(key, values.get(i));
            }
        }

        protected void matched(Key key, Value value) {
        }
    }

    public static interface Predicate<Key> {
        public boolean isInterestedInKeysBetween(Key var1, Key var2);

        public boolean isInterestedInKey(Key var1);
    }
}

