/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.kahadb.disk.index;

import com.primeton.pmq.store.kahadb.disk.index.Index;
import com.primeton.pmq.store.kahadb.disk.index.ListNode;
import com.primeton.pmq.store.kahadb.disk.page.Page;
import com.primeton.pmq.store.kahadb.disk.page.PageFile;
import com.primeton.pmq.store.kahadb.disk.page.Transaction;
import com.primeton.pmq.store.kahadb.disk.util.Marshaller;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListIndex<Key, Value>
implements Index<Key, Value> {
    private static final Logger LOG = LoggerFactory.getLogger(ListIndex.class);
    public static final long NOT_SET = -1L;
    protected PageFile pageFile;
    protected long headPageId;
    protected long tailPageId;
    private AtomicLong size = new AtomicLong(0L);
    protected AtomicBoolean loaded = new AtomicBoolean();
    private ListNode.NodeMarshaller<Key, Value> marshaller;
    private Marshaller<Key> keyMarshaller;
    private Marshaller<Value> valueMarshaller;
    private ListNode<Key, Value> lastGetNodeCache = null;
    private Map.Entry<Key, Value> lastGetEntryCache = null;
    private WeakReference<Transaction> lastCacheTxSrc = new WeakReference<Object>(null);

    public ListIndex() {
    }

    public ListIndex(PageFile pageFile, long headPageId) {
        this.pageFile = pageFile;
        this.setHeadPageId(headPageId);
    }

    public ListIndex(PageFile pageFile, Page page) {
        this(pageFile, page.getPageId());
    }

    @Override
    public synchronized void load(Transaction tx) throws IOException {
        if (this.loaded.compareAndSet(false, true)) {
            LOG.debug("loading");
            if (this.keyMarshaller == null) {
                throw new IllegalArgumentException("The key marshaller must be set before loading the ListIndex");
            }
            if (this.valueMarshaller == null) {
                throw new IllegalArgumentException("The value marshaller must be set before loading the ListIndex");
            }
            this.marshaller = new ListNode.NodeMarshaller<Key, Value>(this.keyMarshaller, this.valueMarshaller);
            Page<ListNode<Key, Value>> p = tx.load(this.getHeadPageId(), null);
            if (p.getType() == 0) {
                ListNode<Key, Value> root = this.createNode(p);
                this.storeNode(tx, root, true);
                this.setHeadPageId(p.getPageId());
                this.setTailPageId(this.getHeadPageId());
            } else {
                ListNode<Key, Value> node = this.loadNode(tx, this.getHeadPageId());
                this.setTailPageId(this.getHeadPageId());
                this.size.addAndGet(node.size(tx));
                this.onLoad(node, tx);
                while (node.getNext() != -1L) {
                    node = this.loadNode(tx, node.getNext());
                    this.size.addAndGet(node.size(tx));
                    this.onLoad(node, tx);
                    this.setTailPageId(node.getPageId());
                }
            }
        }
    }

    protected void onLoad(ListNode<Key, Value> node, Transaction tx) {
    }

    @Override
    public synchronized void unload(Transaction tx) {
        if (this.loaded.compareAndSet(true, false)) {
            // empty if block
        }
    }

    protected ListNode<Key, Value> getHead(Transaction tx) throws IOException {
        return this.loadNode(tx, this.getHeadPageId());
    }

    protected ListNode<Key, Value> getTail(Transaction tx) throws IOException {
        return this.loadNode(tx, this.getTailPageId());
    }

    @Override
    public synchronized boolean containsKey(Transaction tx, Key key) throws IOException {
        this.assertLoaded();
        if (this.size.get() == 0L) {
            return false;
        }
        Iterator<Map.Entry<Key, Value>> iterator = this.iterator(tx);
        while (iterator.hasNext()) {
            Map.Entry<Key, Value> candidate = iterator.next();
            if (!key.equals(candidate.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Value get(Transaction tx, Key key) throws IOException {
        this.assertLoaded();
        Iterator<Map.Entry<Key, Value>> iterator = this.iterator(tx);
        while (iterator.hasNext()) {
            Map.Entry<Key, Value> candidate = iterator.next();
            if (!key.equals(candidate.getKey())) continue;
            this.lastGetNodeCache = ((ListNode.ListIterator)iterator).getCurrent();
            this.lastGetEntryCache = candidate;
            this.lastCacheTxSrc = new WeakReference<Transaction>(tx);
            return candidate.getValue();
        }
        return null;
    }

    @Override
    public synchronized Value put(Transaction tx, Key key, Value value) throws IOException {
        Map.Entry<Key, Value> entry;
        Iterator<Map.Entry<Key, Value>> iterator;
        Value oldValue = null;
        if (this.lastGetNodeCache != null && tx.equals(this.lastCacheTxSrc.get())) {
            if (this.lastGetEntryCache.getKey().equals(key)) {
                oldValue = this.lastGetEntryCache.setValue(value);
                this.lastGetEntryCache.setValue(value);
                this.lastGetNodeCache.storeUpdate(tx);
                this.flushCache();
                return oldValue;
            }
            iterator = this.lastGetNodeCache.iterator(tx);
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (!entry.getKey().equals(key)) continue;
                oldValue = entry.setValue(value);
                ((ListNode.ListIterator)iterator).getCurrent().storeUpdate(tx);
                this.flushCache();
                return oldValue;
            }
        } else {
            this.flushCache();
        }
        iterator = this.iterator(tx);
        while (iterator.hasNext() && ((ListNode.ListIterator)iterator).getCurrent() != this.lastGetNodeCache) {
            entry = iterator.next();
            if (!entry.getKey().equals(key)) continue;
            oldValue = entry.setValue(value);
            ((ListNode.ListIterator)iterator).getCurrent().storeUpdate(tx);
            this.flushCache();
            return oldValue;
        }
        this.flushCache();
        return this.add(tx, key, value);
    }

    public synchronized Value add(Transaction tx, Key key, Value value) throws IOException {
        this.assertLoaded();
        this.getTail(tx).put(tx, key, value);
        this.size.incrementAndGet();
        this.flushCache();
        return null;
    }

    public synchronized Value addFirst(Transaction tx, Key key, Value value) throws IOException {
        this.assertLoaded();
        this.getHead(tx).addFirst(tx, key, value);
        this.size.incrementAndGet();
        this.flushCache();
        return null;
    }

    @Override
    public synchronized Value remove(Transaction tx, Key key) throws IOException {
        Map.Entry<Key, Value> entry;
        Iterator<Map.Entry<Key, Value>> iterator;
        this.assertLoaded();
        if (this.size.get() == 0L) {
            return null;
        }
        if (this.lastGetNodeCache != null && tx.equals(this.lastCacheTxSrc.get())) {
            iterator = this.lastGetNodeCache.iterator(tx);
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (!entry.getKey().equals(key)) continue;
                iterator.remove();
                this.flushCache();
                return entry.getValue();
            }
        } else {
            this.flushCache();
        }
        iterator = this.iterator(tx);
        while (iterator.hasNext() && ((ListNode.ListIterator)iterator).getCurrent() != this.lastGetNodeCache) {
            entry = iterator.next();
            if (!entry.getKey().equals(key)) continue;
            iterator.remove();
            this.flushCache();
            return entry.getValue();
        }
        return null;
    }

    public void onRemove(Map.Entry<Key, Value> removed) {
        this.size.decrementAndGet();
        this.flushCache();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public synchronized void clear(Transaction tx) throws IOException {
        Iterator<ListNode<Key, Value>> iterator = this.listNodeIterator(tx);
        while (iterator.hasNext()) {
            ListNode<Key, Value> candidate = iterator.next();
            candidate.clear(tx);
            tx.commit();
        }
        this.flushCache();
        this.size.set(0L);
    }

    public synchronized Iterator<ListNode<Key, Value>> listNodeIterator(Transaction tx) throws IOException {
        return this.getHead(tx).listNodeIterator(tx);
    }

    public synchronized boolean isEmpty(Transaction tx) throws IOException {
        return this.getHead(tx).isEmpty(tx);
    }

    @Override
    public synchronized Iterator<Map.Entry<Key, Value>> iterator(Transaction tx) throws IOException {
        return this.getHead(tx).iterator(tx);
    }

    public synchronized Iterator<Map.Entry<Key, Value>> iterator(Transaction tx, long initialPosition) throws IOException {
        return this.getHead(tx).iterator(tx, initialPosition);
    }

    public synchronized Map.Entry<Key, Value> getFirst(Transaction tx) throws IOException {
        return this.getHead(tx).getFirst(tx);
    }

    public synchronized Map.Entry<Key, Value> getLast(Transaction tx) throws IOException {
        return this.getTail(tx).getLast(tx);
    }

    private void assertLoaded() throws IllegalStateException {
        if (!this.loaded.get()) {
            throw new IllegalStateException("TheListIndex is not loaded");
        }
    }

    ListNode<Key, Value> loadNode(Transaction tx, long pageId) throws IOException {
        Page page = tx.load(pageId, this.marshaller);
        ListNode node = (ListNode)page.get();
        node.setPage(page);
        node.setContainingList(this);
        return node;
    }

    ListNode<Key, Value> createNode(Page<ListNode<Key, Value>> page) throws IOException {
        ListNode<Key, Value> node = new ListNode<Key, Value>();
        node.setPage(page);
        page.set(node);
        node.setContainingList(this);
        return node;
    }

    public ListNode<Key, Value> createNode(Transaction tx) throws IOException {
        return this.createNode(tx.load(tx.allocate().getPageId(), null));
    }

    public void storeNode(Transaction tx, ListNode<Key, Value> node, boolean overflow) throws IOException {
        tx.store(node.getPage(), this.marshaller, overflow);
        this.flushCache();
    }

    public PageFile getPageFile() {
        return this.pageFile;
    }

    public void setPageFile(PageFile pageFile) {
        this.pageFile = pageFile;
    }

    public long getHeadPageId() {
        return this.headPageId;
    }

    public void setHeadPageId(long headPageId) {
        this.headPageId = headPageId;
    }

    public Marshaller<Key> getKeyMarshaller() {
        return this.keyMarshaller;
    }

    @Override
    public void setKeyMarshaller(Marshaller<Key> keyMarshaller) {
        this.keyMarshaller = keyMarshaller;
    }

    public Marshaller<Value> getValueMarshaller() {
        return this.valueMarshaller;
    }

    @Override
    public void setValueMarshaller(Marshaller<Value> valueMarshaller) {
        this.valueMarshaller = valueMarshaller;
    }

    public void setTailPageId(long tailPageId) {
        this.tailPageId = tailPageId;
    }

    public long getTailPageId() {
        return this.tailPageId;
    }

    public long size() {
        return this.size.get();
    }

    private void flushCache() {
        this.lastGetEntryCache = null;
        this.lastGetNodeCache = null;
        this.lastCacheTxSrc.clear();
    }
}

