/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.kahadb.scheduler;

import com.primeton.pmq.broker.scheduler.JobScheduler;
import com.primeton.pmq.broker.scheduler.JobSchedulerStore;
import com.primeton.pmq.protobuf.Buffer;
import com.primeton.pmq.store.kahadb.AbstractKahaDBStore;
import com.primeton.pmq.store.kahadb.JournalCommand;
import com.primeton.pmq.store.kahadb.Visitor;
import com.primeton.pmq.store.kahadb.data.KahaAddScheduledJobCommand;
import com.primeton.pmq.store.kahadb.data.KahaDestroySchedulerCommand;
import com.primeton.pmq.store.kahadb.data.KahaRemoveScheduledJobCommand;
import com.primeton.pmq.store.kahadb.data.KahaRemoveScheduledJobsCommand;
import com.primeton.pmq.store.kahadb.data.KahaRescheduleJobCommand;
import com.primeton.pmq.store.kahadb.data.KahaTraceCommand;
import com.primeton.pmq.store.kahadb.disk.index.BTreeVisitor;
import com.primeton.pmq.store.kahadb.disk.journal.DataFile;
import com.primeton.pmq.store.kahadb.disk.journal.Location;
import com.primeton.pmq.store.kahadb.disk.page.Page;
import com.primeton.pmq.store.kahadb.disk.page.PageFile;
import com.primeton.pmq.store.kahadb.disk.page.Transaction;
import com.primeton.pmq.store.kahadb.disk.util.VariableMarshaller;
import com.primeton.pmq.store.kahadb.scheduler.JobLocation;
import com.primeton.pmq.store.kahadb.scheduler.JobSchedulerImpl;
import com.primeton.pmq.store.kahadb.scheduler.JobSchedulerKahaDBMetaData;
import com.primeton.pmq.store.kahadb.scheduler.UnknownStoreVersionException;
import com.primeton.pmq.store.kahadb.scheduler.legacy.LegacyStoreReplayer;
import com.primeton.pmq.util.ByteSequence;
import com.primeton.pmq.util.IOHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerStoreImpl
extends AbstractKahaDBStore
implements JobSchedulerStore {
    private static final Logger LOG = LoggerFactory.getLogger(JobSchedulerStoreImpl.class);
    private JobSchedulerKahaDBMetaData metaData = new JobSchedulerKahaDBMetaData(this);
    private final MetaDataMarshaller metaDataMarshaller = new MetaDataMarshaller(this);
    private final Map<String, JobSchedulerImpl> schedulers = new HashMap<String, JobSchedulerImpl>();
    private File legacyStoreArchiveDirectory;
    static final UUID SCHEDULER_STORE_TOKEN = UUID.fromString("57ed642b-1ee3-47b3-be6d-b7297d500409");
    static final int CURRENT_VERSION = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobScheduler getJobScheduler(final String name) throws Exception {
        this.indexLock.writeLock().lock();
        try {
            JobSchedulerImpl result = this.schedulers.get(name);
            if (result == null) {
                final JobSchedulerImpl js = new JobSchedulerImpl(this);
                js.setName(name);
                this.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        js.createIndexes(tx);
                        js.load(tx);
                        JobSchedulerStoreImpl.this.metaData.getJobSchedulers().put(tx, name, js);
                    }
                });
                result = js;
                this.schedulers.put(name, js);
                if (this.isStarted()) {
                    result.start();
                }
                this.pageFile.flush();
            }
            JobSchedulerImpl jobSchedulerImpl = result;
            return jobSchedulerImpl;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJobScheduler(final String name) throws Exception {
        boolean result = false;
        this.indexLock.writeLock().lock();
        try {
            final JobSchedulerImpl js = this.schedulers.remove(name);
            boolean bl = result = js != null;
            if (result) {
                js.stop();
                this.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        JobSchedulerStoreImpl.this.metaData.getJobSchedulers().remove(tx, name);
                        js.removeAll(tx);
                    }
                });
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
        return result;
    }

    public void setLegacyStoreArchiveDirectory(File directory) {
        this.legacyStoreArchiveDirectory = directory;
    }

    public File getLegacyStoreArchiveDirectory() {
        if (this.legacyStoreArchiveDirectory == null) {
            this.legacyStoreArchiveDirectory = new File(this.getDirectory(), "legacySchedulerStore");
        }
        return this.legacyStoreArchiveDirectory.getAbsoluteFile();
    }

    @Override
    public void load() throws IOException {
        if (this.opened.compareAndSet(false, true)) {
            this.getJournal().start();
            try {
                this.loadPageFile();
            }
            catch (UnknownStoreVersionException ex) {
                LOG.info("Can't start until store update is performed.");
                this.upgradeFromLegacy();
                this.getJournal().start();
                this.loadPageFile();
                LOG.info("Update from legacy Scheduler store completed successfully.");
            }
            catch (Throwable t) {
                LOG.warn("Index corrupted. Recovering the index through journal replay. Cause: {}", (Object)t.toString());
                LOG.debug("Index load failure", t);
                try {
                    this.pageFile.unload();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.isArchiveCorruptedIndex()) {
                    this.pageFile.archive();
                } else {
                    this.pageFile.delete();
                }
                this.metaData = new JobSchedulerKahaDBMetaData(this);
                this.pageFile = null;
                this.loadPageFile();
            }
            this.startCheckpoint();
            this.recover();
        }
        LOG.info("{} started.", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() throws IOException {
        if (this.opened.compareAndSet(true, false)) {
            for (JobSchedulerImpl js : this.schedulers.values()) {
                try {
                    js.stop();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            this.indexLock.writeLock().lock();
            try {
                if (this.pageFile != null && this.pageFile.isLoaded()) {
                    this.metaData.setState(1);
                    if (this.metaData.getPage() != null) {
                        this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                            @Override
                            public void execute(Transaction tx) throws IOException {
                                tx.store(JobSchedulerStoreImpl.this.metaData.getPage(), JobSchedulerStoreImpl.this.metaDataMarshaller, true);
                            }
                        });
                    }
                }
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
            this.checkpointLock.writeLock().lock();
            try {
                if (this.metaData.getPage() != null) {
                    this.checkpointUpdate(true);
                }
            }
            finally {
                this.checkpointLock.writeLock().unlock();
            }
            Object object = this.checkpointThreadLock;
            synchronized (object) {
                if (this.checkpointThread != null) {
                    try {
                        this.checkpointThread.join();
                        this.checkpointThread = null;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.pageFile != null) {
                this.pageFile.unload();
                this.pageFile = null;
            }
            if (this.journal != null) {
                this.journal.close();
                this.journal = null;
            }
            this.metaData = new JobSchedulerKahaDBMetaData(this);
        }
        LOG.info("{} stopped.", (Object)this);
    }

    private void loadPageFile() throws IOException {
        this.indexLock.writeLock().lock();
        try {
            final PageFile pageFile = this.getPageFile();
            pageFile.load();
            pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    Page<Object> page;
                    if (pageFile.getPageCount() == 0L) {
                        page = tx.allocate();
                        assert (page.getPageId() == 0L);
                        page.set(JobSchedulerStoreImpl.this.metaData);
                        JobSchedulerStoreImpl.this.metaData.setPage(page);
                        JobSchedulerStoreImpl.this.metaData.setState(1);
                        JobSchedulerStoreImpl.this.metaData.initialize(tx);
                        tx.store(JobSchedulerStoreImpl.this.metaData.getPage(), JobSchedulerStoreImpl.this.metaDataMarshaller, true);
                    } else {
                        page = null;
                        page = tx.load(0L, JobSchedulerStoreImpl.this.metaDataMarshaller);
                        JobSchedulerStoreImpl.this.metaData = (JobSchedulerKahaDBMetaData)page.get();
                        JobSchedulerStoreImpl.this.metaData.setPage(page);
                    }
                    JobSchedulerStoreImpl.this.metaData.load(tx);
                    JobSchedulerStoreImpl.this.metaData.loadScheduler(tx, JobSchedulerStoreImpl.this.schedulers);
                    for (JobSchedulerImpl js : JobSchedulerStoreImpl.this.schedulers.values()) {
                        try {
                            js.start();
                        }
                        catch (Exception e) {
                            LOG.error("Failed to load " + js.getName(), e);
                        }
                    }
                }
            });
            pageFile.flush();
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    private void upgradeFromLegacy() throws IOException {
        this.journal.close();
        this.journal = null;
        try {
            this.pageFile.unload();
            this.pageFile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        File storeDir = this.getDirectory().getAbsoluteFile();
        File storeArchiveDir = this.getLegacyStoreArchiveDirectory();
        LOG.info("Attempting to move old store files from {} to {}", (Object)storeDir, (Object)storeArchiveDir);
        IOHelper.moveFiles(storeDir, storeArchiveDir, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".data") || name.endsWith(".redo") || name.endsWith(".log") || name.endsWith(".free");
            }
        });
        this.getJournal().start();
        this.metaData = new JobSchedulerKahaDBMetaData(this);
        this.pageFile = null;
        this.loadPageFile();
        LegacyStoreReplayer replayer = new LegacyStoreReplayer(this.getLegacyStoreArchiveDirectory());
        replayer.load();
        replayer.startReplay(this);
        this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                tx.store(JobSchedulerStoreImpl.this.metaData.getPage(), JobSchedulerStoreImpl.this.metaDataMarshaller, true);
            }
        });
        this.checkpointUpdate(true);
        this.getJournal().close();
        this.getPageFile().unload();
    }

    @Override
    protected void checkpointUpdate(Transaction tx, boolean cleanup) throws IOException {
        LOG.debug("Job Scheduler Store Checkpoint started.");
        Location lastUpdate = this.metaData.getLastUpdateLocation();
        this.metaData.setState(2);
        tx.store(this.metaData.getPage(), this.metaDataMarshaller, true);
        this.pageFile.flush();
        if (cleanup) {
            TreeSet<Integer> completeFileSet = new TreeSet<Integer>(this.journal.getFileMap().keySet());
            final TreeSet<Integer> gcCandidateSet = new TreeSet<Integer>((SortedSet<Integer>)completeFileSet);
            LOG.trace("Last update: {}, full gc candidates set: {}", (Object)lastUpdate, (Object)gcCandidateSet);
            if (lastUpdate != null) {
                gcCandidateSet.remove(lastUpdate.getDataFileId());
            }
            this.metaData.getJournalRC().visit(tx, new BTreeVisitor<Integer, Integer>(){

                @Override
                public void visit(List<Integer> keys, List<Integer> values) {
                    for (Integer key : keys) {
                        if (!gcCandidateSet.remove(key)) continue;
                        LOG.trace("Removed referenced file: {} from GC set", (Object)key);
                    }
                }

                @Override
                public boolean isInterestedInKeysBetween(Integer first, Integer second) {
                    return true;
                }
            });
            LOG.trace("gc candidates after reference check: {}", (Object)gcCandidateSet);
            if (!gcCandidateSet.isEmpty()) {
                Iterator<Map.Entry<Integer, List<Integer>>> removals = this.metaData.getRemoveLocationTracker().iterator(tx);
                ArrayList<Integer> orphans = new ArrayList<Integer>();
                while (removals.hasNext()) {
                    boolean orphanedRemove = true;
                    Map.Entry<Integer, List<Integer>> entry = removals.next();
                    if (!gcCandidateSet.contains(entry.getKey())) continue;
                    for (Integer addLocation : entry.getValue()) {
                        if (!completeFileSet.contains(addLocation)) continue;
                        LOG.trace("A remove in log {} has an add still in existance in {}.", (Object)entry.getKey(), (Object)addLocation);
                        orphanedRemove = false;
                        break;
                    }
                    if (!orphanedRemove) {
                        gcCandidateSet.remove(entry.getKey());
                        continue;
                    }
                    LOG.trace("All removes in log {} are orphaned, file can be GC'd", (Object)entry.getKey());
                    orphans.add(entry.getKey());
                }
                for (Integer orphan : orphans) {
                    this.metaData.getRemoveLocationTracker().remove(tx, orphan);
                }
            }
            LOG.trace("gc candidates after removals check: {}", (Object)gcCandidateSet);
            if (!gcCandidateSet.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cleanup removing the data files: " + gcCandidateSet);
                }
                this.journal.removeDataFiles(gcCandidateSet);
            }
        }
        LOG.debug("Job Scheduler Store Checkpoint complete.");
    }

    protected void incrementJournalCount(Transaction tx, Location location) throws IOException {
        int logId = location.getDataFileId();
        Integer val = this.metaData.getJournalRC().get(tx, logId);
        int refCount = val != null ? val + 1 : 1;
        this.metaData.getJournalRC().put(tx, logId, refCount);
    }

    protected void decrementJournalCount(Transaction tx, Location location) throws IOException {
        int logId = location.getDataFileId();
        Integer refCount = this.metaData.getJournalRC().get(tx, logId);
        if (refCount != null) {
            int refCountValue = refCount;
            if (--refCountValue <= 0) {
                this.metaData.getJournalRC().remove(tx, logId);
            } else {
                this.metaData.getJournalRC().put(tx, logId, refCountValue);
            }
        }
    }

    protected void decrementJournalCount(Transaction tx, HashMap<Integer, Integer> decrementsByFileIds) throws IOException {
        for (Map.Entry<Integer, Integer> entry : decrementsByFileIds.entrySet()) {
            int logId = entry.getKey();
            Integer refCount = this.metaData.getJournalRC().get(tx, logId);
            if (refCount == null) continue;
            int refCountValue = refCount;
            if ((refCountValue -= entry.getValue().intValue()) <= 0) {
                this.metaData.getJournalRC().remove(tx, logId);
                continue;
            }
            this.metaData.getJournalRC().put(tx, logId, refCountValue);
        }
    }

    protected void referenceRemovedLocation(Transaction tx, Location location, JobLocation removedJob) throws IOException {
        int logId = location.getDataFileId();
        List<Integer> removed = this.metaData.getRemoveLocationTracker().get(tx, logId);
        if (removed == null) {
            removed = new ArrayList<Integer>();
        }
        removed.add(removedJob.getLocation().getDataFileId());
        this.metaData.getRemoveLocationTracker().put(tx, logId, removed);
    }

    protected void referenceRemovedLocation(Transaction tx, Location location, List<Integer> removedJobsFileId) throws IOException {
        int logId = location.getDataFileId();
        List<Integer> removed = this.metaData.getRemoveLocationTracker().get(tx, logId);
        if (removed == null) {
            removed = new ArrayList<Integer>();
        }
        removed.addAll(removedJobsFileId);
        this.metaData.getRemoveLocationTracker().put(tx, logId, removed);
    }

    protected ByteSequence getPayload(Location location) throws IOException {
        KahaAddScheduledJobCommand job = (KahaAddScheduledJobCommand)this.load(location);
        Buffer payload = job.getPayload();
        return new ByteSequence(payload.getData(), payload.getOffset(), payload.getLength());
    }

    public void readLockIndex() {
        this.indexLock.readLock().lock();
    }

    public void readUnlockIndex() {
        this.indexLock.readLock().unlock();
    }

    public void writeLockIndex() {
        this.indexLock.writeLock().lock();
    }

    public void writeUnlockIndex() {
        this.indexLock.writeLock().unlock();
    }

    public String toString() {
        return "JobSchedulerStore: " + this.getDirectory();
    }

    @Override
    protected String getPageFileName() {
        return "scheduleDB";
    }

    @Override
    protected File getDefaultDataDirectory() {
        return new File(IOHelper.getDefaultDataDirectory(), "delayedDB");
    }

    protected void doRecover(JournalCommand<?> data, Location location, Location inDoubtlocation) throws IOException {
        if (inDoubtlocation != null && location.compareTo(inDoubtlocation) >= 0) {
            this.process(data, location);
        }
    }

    @Override
    protected void process(JournalCommand<?> data, final Location location) throws IOException {
        data.visit(new Visitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(final KahaAddScheduledJobCommand command) throws IOException {
                JobSchedulerStoreImpl.this.indexLock.writeLock().lock();
                try {
                    JobSchedulerImpl scheduler;
                    try {
                        scheduler = (JobSchedulerImpl)JobSchedulerStoreImpl.this.getJobScheduler(command.getScheduler());
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    JobSchedulerStoreImpl.this.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            scheduler.process(tx, command, location);
                        }
                    });
                    JobSchedulerStoreImpl.this.processLocation(location);
                }
                finally {
                    JobSchedulerStoreImpl.this.indexLock.writeLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(final KahaRemoveScheduledJobCommand command) throws IOException {
                JobSchedulerStoreImpl.this.indexLock.writeLock().lock();
                try {
                    JobSchedulerImpl scheduler;
                    try {
                        scheduler = (JobSchedulerImpl)JobSchedulerStoreImpl.this.getJobScheduler(command.getScheduler());
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    JobSchedulerStoreImpl.this.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            scheduler.process(tx, command, location);
                        }
                    });
                    JobSchedulerStoreImpl.this.processLocation(location);
                }
                finally {
                    JobSchedulerStoreImpl.this.indexLock.writeLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(final KahaRemoveScheduledJobsCommand command) throws IOException {
                JobSchedulerStoreImpl.this.indexLock.writeLock().lock();
                try {
                    JobSchedulerImpl scheduler;
                    try {
                        scheduler = (JobSchedulerImpl)JobSchedulerStoreImpl.this.getJobScheduler(command.getScheduler());
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    JobSchedulerStoreImpl.this.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            scheduler.process(tx, command, location);
                        }
                    });
                    JobSchedulerStoreImpl.this.processLocation(location);
                }
                finally {
                    JobSchedulerStoreImpl.this.indexLock.writeLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(final KahaRescheduleJobCommand command) throws IOException {
                JobSchedulerStoreImpl.this.indexLock.writeLock().lock();
                try {
                    JobSchedulerImpl scheduler;
                    try {
                        scheduler = (JobSchedulerImpl)JobSchedulerStoreImpl.this.getJobScheduler(command.getScheduler());
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    JobSchedulerStoreImpl.this.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            scheduler.process(tx, command, location);
                        }
                    });
                    JobSchedulerStoreImpl.this.processLocation(location);
                }
                finally {
                    JobSchedulerStoreImpl.this.indexLock.writeLock().unlock();
                }
            }

            @Override
            public void visit(KahaDestroySchedulerCommand command) {
                try {
                    JobSchedulerStoreImpl.this.removeJobScheduler(command.getScheduler());
                }
                catch (Exception e) {
                    LOG.warn("Failed to remove scheduler: {}", (Object)command.getScheduler());
                }
                JobSchedulerStoreImpl.this.processLocation(location);
            }

            @Override
            public void visit(KahaTraceCommand command) {
                JobSchedulerStoreImpl.this.processLocation(location);
            }
        });
    }

    protected void processLocation(Location location) {
        this.indexLock.writeLock().lock();
        try {
            this.metaData.setLastUpdateLocation(location);
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() throws IllegalStateException, IOException {
        this.indexLock.writeLock().lock();
        try {
            Location lastIndoubtPosition;
            long start2 = System.currentTimeMillis();
            Location recoveryPosition = lastIndoubtPosition = this.getRecoveryPosition();
            if (recoveryPosition != null) {
                int redoCounter = 0;
                LOG.info("Recovering from the scheduled job journal @" + recoveryPosition);
                while (recoveryPosition != null) {
                    try {
                        JournalCommand<?> message = this.load(recoveryPosition);
                        this.metaData.setLastUpdateLocation(recoveryPosition);
                        this.doRecover(message, recoveryPosition, lastIndoubtPosition);
                        ++redoCounter;
                    }
                    catch (IOException failedRecovery) {
                        if (this.isIgnoreMissingJournalfiles()) {
                            LOG.debug("Failed to recover data at position:" + recoveryPosition, failedRecovery);
                            this.journal.corruptRecoveryLocation(recoveryPosition);
                        }
                        throw new IOException("Failed to recover data at position:" + recoveryPosition, failedRecovery);
                    }
                    recoveryPosition = this.journal.getNextLocation(recoveryPosition);
                    if (!LOG.isInfoEnabled() || redoCounter % 100000 != 0) continue;
                    LOG.info("@ {}, {} entries recovered ..", (Object)recoveryPosition, (Object)redoCounter);
                }
                long end = System.currentTimeMillis();
                LOG.info("Recovery replayed {} operations from the journal in {} seconds.", (Object)redoCounter, (Object)Float.valueOf((float)(end - start2) / 1000.0f));
            }
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    JobSchedulerStoreImpl.this.recoverIndex(tx);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    private Location getRecoveryPosition() throws IOException {
        Location result = null;
        if (!this.isForceRecoverIndex() && this.metaData.getLastUpdateLocation() != null) {
            result = this.metaData.getLastUpdateLocation();
        }
        return this.journal.getNextLocation(result);
    }

    private void recoverIndex(Transaction tx) throws IOException {
        long start2 = System.currentTimeMillis();
        Location lastAppendLocation = this.journal.getLastAppendLocation();
        long undoCounter = 0L;
        Iterator<Map.Entry<String, JobSchedulerImpl>> i = this.metaData.getJobSchedulers().iterator(tx);
        while (i.hasNext()) {
            Map.Entry<String, JobSchedulerImpl> entry = i.next();
            JobSchedulerImpl scheduler = entry.getValue();
            Iterator<JobLocation> jobLocationIterator = scheduler.getAllScheduledJobs(tx);
            while (jobLocationIterator.hasNext()) {
                JobLocation job = jobLocationIterator.next();
                if (job.getLocation().compareTo(lastAppendLocation) < 0 || !scheduler.removeJobAtTime(tx, job.getJobId(), job.getNextTime())) continue;
                LOG.trace("Removed Job past last appened in the journal: {}", (Object)job.getJobId());
                ++undoCounter;
            }
        }
        if (undoCounter > 0L) {
            long end = System.currentTimeMillis();
            LOG.info("Rolled back {} messages from the index in {} seconds.", (Object)undoCounter, (Object)Float.valueOf((float)(end - start2) / 1000.0f));
            undoCounter = 0L;
        }
        HashSet<Integer> missingJournalFiles = new HashSet<Integer>();
        Iterator<Map.Entry<String, JobSchedulerImpl>> i2 = this.metaData.getJobSchedulers().iterator(tx);
        while (i2.hasNext()) {
            Map.Entry<String, JobSchedulerImpl> entry = i2.next();
            JobSchedulerImpl scheduler = entry.getValue();
            Iterator<JobLocation> jobLocationIterator = scheduler.getAllScheduledJobs(tx);
            while (jobLocationIterator.hasNext()) {
                JobLocation job = jobLocationIterator.next();
                missingJournalFiles.add(job.getLocation().getDataFileId());
                if (job.getLastUpdate() == null) continue;
                missingJournalFiles.add(job.getLastUpdate().getDataFileId());
            }
        }
        missingJournalFiles.removeAll(this.journal.getFileMap().keySet());
        if (!missingJournalFiles.isEmpty()) {
            LOG.info("Some journal files are missing: {}", (Object)missingJournalFiles);
        }
        HashSet<Location> corruptedLocations = new HashSet<Location>();
        if (this.isCheckForCorruptJournalFiles()) {
            Collection<DataFile> dataFiles = this.journal.getFileMap().values();
            for (DataFile dataFile : dataFiles) {
                int id = dataFile.getDataFileId();
                for (long offset : dataFile.getCorruptedBlocks()) {
                    corruptedLocations.add(new Location(id, (int)offset));
                }
            }
            if (!corruptedLocations.isEmpty()) {
                LOG.debug("Found some corrupted data blocks in the journal: {}", (Object)corruptedLocations.size());
            }
        }
        if (!missingJournalFiles.isEmpty() || !corruptedLocations.isEmpty()) {
            if (!this.isIgnoreMissingJournalfiles()) {
                throw new IOException("Detected missing/corrupt journal files.");
            }
            undoCounter = this.removeJobsInMissingOrCorruptJounralFiles(tx, missingJournalFiles, corruptedLocations);
            this.removeJournalRCForMissingFiles(tx, missingJournalFiles);
        }
        if (undoCounter > 0L) {
            long end = System.currentTimeMillis();
            LOG.info("Detected missing/corrupt journal files.  Dropped {} jobs from the index in {} seconds.", (Object)undoCounter, (Object)Float.valueOf((float)(end - start2) / 1000.0f));
        }
    }

    private void removeJournalRCForMissingFiles(Transaction tx, Set<Integer> missing) throws IOException {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, Integer>> references = this.metaData.getJournalRC().iterator(tx);
        while (references.hasNext()) {
            int dataFileId = references.next().getKey();
            if (!missing.contains(dataFileId)) continue;
            matches.add(dataFileId);
        }
        for (Integer match : matches) {
            this.metaData.getJournalRC().remove(tx, match);
        }
    }

    private int removeJobsInMissingOrCorruptJounralFiles(Transaction tx, Set<Integer> missing, Set<Location> corrupted) throws IOException {
        int removed = 0;
        Iterator<Map.Entry<String, JobSchedulerImpl>> i = this.metaData.getJobSchedulers().iterator(tx);
        while (i.hasNext()) {
            Map.Entry<String, JobSchedulerImpl> entry = i.next();
            JobSchedulerImpl scheduler = entry.getValue();
            Iterator<JobLocation> jobLocationIterator = scheduler.getAllScheduledJobs(tx);
            while (jobLocationIterator.hasNext()) {
                JobLocation job = jobLocationIterator.next();
                if (missing.contains(job.getLocation().getDataFileId())) {
                    scheduler.removeJobAtTime(tx, job.getJobId(), job.getNextTime());
                    ++removed;
                    continue;
                }
                if (!corrupted.contains(job.getLocation())) continue;
                scheduler.removeJobAtTime(tx, job.getJobId(), job.getNextTime());
                ++removed;
            }
        }
        return removed;
    }

    private class MetaDataMarshaller
    extends VariableMarshaller<JobSchedulerKahaDBMetaData> {
        private final JobSchedulerStoreImpl store;

        MetaDataMarshaller(JobSchedulerStoreImpl store2) {
            this.store = store2;
        }

        @Override
        public JobSchedulerKahaDBMetaData readPayload(DataInput dataIn) throws IOException {
            JobSchedulerKahaDBMetaData rc = new JobSchedulerKahaDBMetaData(this.store);
            rc.read(dataIn);
            return rc;
        }

        @Override
        public void writePayload(JobSchedulerKahaDBMetaData object, DataOutput dataOut) throws IOException {
            object.write(dataOut);
        }
    }
}

