/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.kahadb.scheduler.legacy;

import com.primeton.pmq.store.kahadb.data.KahaAddScheduledJobCommand;
import com.primeton.pmq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import com.primeton.pmq.store.kahadb.scheduler.legacy.LegacyJobImpl;
import com.primeton.pmq.store.kahadb.scheduler.legacy.LegacyJobSchedulerImpl;
import com.primeton.pmq.store.kahadb.scheduler.legacy.LegacyJobSchedulerStoreImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyStoreReplayer {
    static final Logger LOG = LoggerFactory.getLogger(LegacyStoreReplayer.class);
    private LegacyJobSchedulerStoreImpl store;
    private final File legacyStoreDirectory;

    public LegacyStoreReplayer(File directory) {
        this.legacyStoreDirectory = directory;
    }

    public void load() throws IOException {
        this.store = new LegacyJobSchedulerStoreImpl();
        this.store.setDirectory(this.legacyStoreDirectory);
        this.store.setFailIfDatabaseIsLocked(true);
        try {
            this.store.start();
        }
        catch (IOException ioe) {
            LOG.warn("Legacy store load failed: ", ioe);
            throw ioe;
        }
        catch (Exception e) {
            LOG.warn("Legacy store load failed: ", e);
            throw new IOException(e);
        }
    }

    public void unload() throws IOException {
        if (this.store != null) {
            try {
                this.store.stop();
            }
            catch (Exception e) {
                LOG.warn("Legacy store unload failed: ", e);
                throw new IOException(e);
            }
            finally {
                this.store = null;
            }
        }
    }

    public void startReplay(JobSchedulerStoreImpl targetStore) throws IOException {
        this.checkLoaded();
        if (targetStore == null) {
            throw new IOException("Cannot replay to a null store");
        }
        try {
            Set<String> schedulers = this.store.getJobSchedulerNames();
            if (!schedulers.isEmpty()) {
                for (String name : schedulers) {
                    LegacyJobSchedulerImpl scheduler = this.store.getJobScheduler(name);
                    LOG.info("Replay of legacy store {} starting.", (Object)name);
                    this.replayScheduler(scheduler, targetStore);
                }
            }
            LOG.info("Replay of legacy store complate.");
        }
        catch (IOException ioe) {
            LOG.warn("Failed during replay of legacy store: ", ioe);
            throw ioe;
        }
        catch (Exception e) {
            LOG.warn("Failed during replay of legacy store: ", e);
            throw new IOException(e);
        }
    }

    private final void replayScheduler(LegacyJobSchedulerImpl legacy, JobSchedulerStoreImpl target) throws Exception {
        List<LegacyJobImpl> jobs = legacy.getAllJobs();
        String schedulerName = legacy.getName();
        for (LegacyJobImpl job : jobs) {
            LOG.trace("Storing job from legacy store to new store: {}", (Object)job);
            KahaAddScheduledJobCommand newJob = new KahaAddScheduledJobCommand();
            newJob.setScheduler(schedulerName);
            newJob.setJobId(job.getJobId());
            newJob.setStartTime(job.getStartTime());
            newJob.setCronEntry(job.getCronEntry());
            newJob.setDelay(job.getDelay());
            newJob.setPeriod(job.getPeriod());
            newJob.setRepeat(job.getRepeat());
            newJob.setNextExecutionTime(job.getNextExecutionTime());
            newJob.setPayload(job.getPayload());
            target.store(newJob);
        }
    }

    private final void checkLoaded() throws IOException {
        if (this.store == null) {
            throw new IOException("Cannot replay until legacy store is loaded.");
        }
    }
}

