/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.store.memory;

import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.scheduler.JobSchedulerStore;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.ProducerId;
import com.primeton.pmq.store.MessageStore;
import com.primeton.pmq.store.NoLocalSubscriptionAware;
import com.primeton.pmq.store.PersistenceAdapter;
import com.primeton.pmq.store.ProxyMessageStore;
import com.primeton.pmq.store.TopicMessageStore;
import com.primeton.pmq.store.TransactionStore;
import com.primeton.pmq.store.memory.MemoryMessageStore;
import com.primeton.pmq.store.memory.MemoryTopicMessageStore;
import com.primeton.pmq.store.memory.MemoryTransactionStore;
import com.primeton.pmq.usage.SystemUsage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryPersistenceAdapter
implements PersistenceAdapter,
NoLocalSubscriptionAware {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryPersistenceAdapter.class);
    MemoryTransactionStore transactionStore;
    ConcurrentMap<PMQDestination, TopicMessageStore> topics = new ConcurrentHashMap<PMQDestination, TopicMessageStore>();
    ConcurrentMap<PMQDestination, MessageStore> queues = new ConcurrentHashMap<PMQDestination, MessageStore>();
    private boolean useExternalMessageReferences;

    @Override
    public Set<PMQDestination> getDestinations() {
        HashSet<PMQDestination> rc = new HashSet<PMQDestination>(this.queues.size() + this.topics.size());
        Iterator iter = this.queues.keySet().iterator();
        while (iter.hasNext()) {
            rc.add((PMQDestination)iter.next());
        }
        iter = this.topics.keySet().iterator();
        while (iter.hasNext()) {
            rc.add((PMQDestination)iter.next());
        }
        return rc;
    }

    public static MemoryPersistenceAdapter newInstance(File file) {
        return new MemoryPersistenceAdapter();
    }

    @Override
    public MessageStore createQueueMessageStore(PMQQueue destination) throws IOException {
        MessageStore rc = (MessageStore)this.queues.get(destination);
        if (rc == null) {
            rc = new MemoryMessageStore(destination);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.queues.put(destination, rc);
        }
        return rc;
    }

    @Override
    public TopicMessageStore createTopicMessageStore(PMQTopic destination) throws IOException {
        TopicMessageStore rc = (TopicMessageStore)this.topics.get(destination);
        if (rc == null) {
            rc = new MemoryTopicMessageStore(destination);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.topics.put(destination, rc);
        }
        return rc;
    }

    @Override
    public void removeQueueMessageStore(PMQQueue destination) {
        this.queues.remove(destination);
    }

    @Override
    public void removeTopicMessageStore(PMQTopic destination) {
        this.topics.remove(destination);
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            this.transactionStore = new MemoryTransactionStore(this);
        }
        return this.transactionStore;
    }

    @Override
    public void beginTransaction(ConnectionContext context) {
    }

    @Override
    public void commitTransaction(ConnectionContext context) {
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return 0L;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        MemoryMessageStore store2;
        Iterator iter = this.topics.values().iterator();
        while (iter.hasNext()) {
            store2 = this.asMemoryMessageStore(iter.next());
            if (store2 == null) continue;
            store2.delete();
        }
        iter = this.queues.values().iterator();
        while (iter.hasNext()) {
            store2 = this.asMemoryMessageStore(iter.next());
            if (store2 == null) continue;
            store2.delete();
        }
        if (this.transactionStore != null) {
            this.transactionStore.delete();
        }
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }

    protected MemoryMessageStore asMemoryMessageStore(Object value) {
        MessageStore delegate;
        if (value instanceof MemoryMessageStore) {
            return (MemoryMessageStore)value;
        }
        if (value instanceof ProxyMessageStore && (delegate = ((ProxyMessageStore)value).getDelegate()) instanceof MemoryMessageStore) {
            return (MemoryMessageStore)delegate;
        }
        LOG.warn("Expected an instance of MemoryMessageStore but was: " + value);
        return null;
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
    }

    public String toString() {
        return "MemoryPersistenceAdapter";
    }

    @Override
    public void setBrokerName(String brokerName) {
    }

    @Override
    public void setDirectory(File dir) {
    }

    @Override
    public File getDirectory() {
        return null;
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
    }

    @Override
    public long size() {
        return 0L;
    }

    public void setCreateTransactionStore(boolean create) throws IOException {
        if (create) {
            this.createTransactionStore();
        }
    }

    @Override
    public long getLastProducerSequenceId(ProducerId id) {
        return -1L;
    }

    @Override
    public void allowIOResumption() {
    }

    @Override
    public JobSchedulerStore createJobSchedulerStore() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPersistNoLocal() {
        return true;
    }
}

