/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport;

import com.primeton.pmq.transport.FutureResponse;
import com.primeton.pmq.transport.LogWriter;
import com.primeton.pmq.transport.ResponseCallback;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportFilter;
import com.primeton.pmq.transport.TransportLoggerView;
import java.io.IOException;
import org.slf4j.Logger;

public class TransportLogger
extends TransportFilter {
    private final Logger log;
    private boolean logging;
    private final LogWriter logWriter;
    private TransportLoggerView view;

    public TransportLogger(Transport next, Logger log2, boolean startLogging, LogWriter logWriter) {
        super(next);
        this.log = log2;
        this.logging = startLogging;
        this.logWriter = logWriter;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    @Override
    public Object request(Object command) throws IOException {
        if (this.logging) {
            this.logWriter.logRequest(this.log, command);
        }
        Object rc = super.request(command);
        if (this.logging) {
            this.logWriter.logResponse(this.log, command);
        }
        return rc;
    }

    @Override
    public Object request(Object command, int timeout) throws IOException {
        if (this.logging) {
            this.logWriter.logRequest(this.log, command);
        }
        Object rc = super.request(command, timeout);
        if (this.logging) {
            this.logWriter.logResponse(this.log, command);
        }
        return rc;
    }

    @Override
    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        if (this.logging) {
            this.logWriter.logAsyncRequest(this.log, command);
        }
        FutureResponse rc = this.next.asyncRequest(command, responseCallback);
        return rc;
    }

    @Override
    public void oneway(Object command) throws IOException {
        if (this.logging && this.log.isDebugEnabled()) {
            this.logWriter.logOneWay(this.log, command);
        }
        this.next.oneway(command);
    }

    @Override
    public void onCommand(Object command) {
        if (this.logging && this.log.isDebugEnabled()) {
            this.logWriter.logReceivedCommand(this.log, command);
        }
        this.getTransportListener().onCommand(command);
    }

    @Override
    public void onException(IOException error) {
        if (this.logging && this.log.isDebugEnabled()) {
            this.logWriter.logReceivedException(this.log, error);
        }
        this.getTransportListener().onException(error);
    }

    public TransportLoggerView getView() {
        return this.view;
    }

    public void setView(TransportLoggerView view) {
        this.view = view;
    }

    @Override
    public String toString() {
        return this.next.toString();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.view != null) {
            this.view.unregister();
        }
    }
}

